<?php
#https://en.wikipedia.org/wiki/Currency_symbol#List_of_currency_symbols_currently_in_use

$country_data = array (
	'AF' =>
		array (
			'info' =>
				array (
					'name' => 'Afghanistan',
					'phone_code' => '+93',
				),
			'currency' =>
				array (
					'code' => 'AFN',
					'symbol' => '؋',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AX' =>
		array (
			'info' =>
				array (
					'name' => '&#197;land Islands',
					'phone_code' => '+35818',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AL' =>
		array (
			'info' =>
				array (
					'name' => 'Albania',
					'phone_code' => '+355',
				),
			'currency' =>
				array (
					'code' => 'ALL',
					'symbol' => 'L',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'DZ' =>
		array (
			'info' =>
				array (
					'name' => 'Algeria',
					'phone_code' => '+213',
				),
			'currency' =>
				array (
					'code' => 'DZD',
					'symbol' => 'دج',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AS' =>
		array (
			'info' =>
				array (
					'name' => 'American Samoa',
					'phone_code' => '+1684',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AD' =>
		array (
			'info' =>
				array (
					'name' => 'Andorra',
					'phone_code' => '+376',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AO' =>
		array (
			'info' =>
				array (
					'name' => 'Angola',
					'phone_code' => '+244',
				),
			'currency' =>
				array (
					'code' => 'AOA',
					'symbol' => 'Kz',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'BGO' => 'Bengo',
					'BLU' => 'Benguela',
					'BIE' => 'Bié',
					'CAB' => 'Cabinda',
					'CNN' => 'Cunene',
					'HUA' => 'Huambo',
					'HUI' => 'Huíla',
					'CCU' => 'Kuando Kubango',
					'CNO' => 'Kwanza-Norte',
					'CUS' => 'Kwanza-Sul',
					'LUA' => 'Luanda',
					'LNO' => 'Lunda-Norte',
					'LSU' => 'Lunda-Sul',
					'MAL' => 'Malanje',
					'MOX' => 'Moxico',
					'NAM' => 'Namibe',
					'UIG' => 'Uíge',
					'ZAI' => 'Zaire',
				),
		),
	'AI' =>
		array (
			'info' =>
				array (
					'name' => 'Anguilla',
					'phone_code' => '+1264',
				),
			'currency' =>
				array (
					'code' => 'XCD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AQ' =>
		array (
			'info' =>
				array (
					'name' => 'Antarctica',
					'phone_code' => '',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AG' =>
		array (
			'info' =>
				array (
					'name' => 'Antigua and Barbuda',
					'phone_code' => '+1268',
				),
			'currency' =>
				array (
					'code' => 'XCD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AR' =>
		array (
			'info' =>
				array (
					'name' => 'Argentina',
					'phone_code' => '+54',
				),
			'currency' =>
				array (
					'code' => 'ARS',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'C' => 'Ciudad Aut&oacute;noma de Buenos Aires',
					'B' => 'Buenos Aires',
					'K' => 'Catamarca',
					'H' => 'Chaco',
					'U' => 'Chubut',
					'X' => 'C&oacute;rdoba',
					'W' => 'Corrientes',
					'E' => 'Entre R&iacute;os',
					'P' => 'Formosa',
					'Y' => 'Jujuy',
					'L' => 'La Pampa',
					'F' => 'La Rioja',
					'M' => 'Mendoza',
					'N' => 'Misiones',
					'Q' => 'Neuqu&eacute;n',
					'R' => 'R&iacute;o Negro',
					'A' => 'Salta',
					'J' => 'San Juan',
					'D' => 'San Luis',
					'Z' => 'Santa Cruz',
					'S' => 'Santa Fe',
					'G' => 'Santiago del Estero',
					'V' => 'Tierra del Fuego',
					'T' => 'Tucum&aacute;n',
				),
		),
	'AM' =>
		array (
			'info' =>
				array (
					'name' => 'Armenia',
					'phone_code' => '+374',
				),
			'currency' =>
				array (
					'code' => 'AMD',
					'symbol' => '֏',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AW' =>
		array (
			'info' =>
				array (
					'name' => 'Aruba',
					'phone_code' => '+297',
				),
			'currency' =>
				array (
					'code' => 'AWG',
					'symbol' => 'ƒ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AU' =>
		array (
			'info' =>
				array (
					'name' => 'Australia',
					'phone_code' => '+61',
				),
			'currency' =>
				array (
					'code' => 'AUD',
					'symbol' => 'A$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'AU',
											'state' => '',
											'rate' => '10.0000',
											'name' => 'GST',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'ACT' => 'Australian Capital Territory',
					'NSW' => 'New South Wales',
					'NT' => 'Northern Territory',
					'QLD' => 'Queensland',
					'SA' => 'South Australia',
					'TAS' => 'Tasmania',
					'VIC' => 'Victoria',
					'WA' => 'Western Australia',
				),
		),
	'AT' =>
		array (
			'info' =>
				array (
					'name' => 'Austria',
					'phone_code' => '+43',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AZ' =>
		array (
			'info' =>
				array (
					'name' => 'Azerbaijan',
					'phone_code' => '+994',
				),
			'currency' =>
				array (
					'code' => 'AZN',
					'symbol' => '₼',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BS' =>
		array (
			'info' =>
				array (
					'name' => 'Bahamas',
					'phone_code' => '+1242',
				),
			'currency' =>
				array (
					'code' => 'BSD',
					'symbol' => 'B$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BH' =>
		array (
			'info' =>
				array (
					'name' => 'Bahrain',
					'phone_code' => '+973',
				),
			'currency' =>
				array (
					'code' => 'BHD',
					'symbol' => 'د.ب',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BD' =>
		array (
			'info' =>
				array (
					'name' => 'Bangladesh',
					'phone_code' => '+880',
				),
			'currency' =>
				array (
					'code' => 'BDT',
					'symbol' => '৳',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'BD',
											'state' => '',
											'rate' => '15.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'BD-05' => 'Bagerhat',
					'BD-01' => 'Bandarban',
					'BD-02' => 'Barguna',
					'BD-06' => 'Barishal',
					'BD-07' => 'Bhola',
					'BD-03' => 'Bogura',
					'BD-04' => 'Brahmanbaria',
					'BD-09' => 'Chandpur',
					'BD-10' => 'Chattogram',
					'BD-12' => 'Chuadanga',
					'BD-11' => 'Cox\'s Bazar',
					'BD-08' => 'Cumilla',
					'BD-13' => 'Dhaka',
					'BD-14' => 'Dinajpur',
					'BD-15' => 'Faridpur ',
					'BD-16' => 'Feni',
					'BD-19' => 'Gaibandha',
					'BD-18' => 'Gazipur',
					'BD-17' => 'Gopalganj',
					'BD-20' => 'Habiganj',
					'BD-21' => 'Jamalpur',
					'BD-22' => 'Jashore',
					'BD-25' => 'Jhalokati',
					'BD-23' => 'Jhenaidah',
					'BD-24' => 'Joypurhat',
					'BD-29' => 'Khagrachhari',
					'BD-27' => 'Khulna',
					'BD-26' => 'Kishoreganj',
					'BD-28' => 'Kurigram',
					'BD-30' => 'Kushtia',
					'BD-31' => 'Lakshmipur',
					'BD-32' => 'Lalmonirhat',
					'BD-36' => 'Madaripur',
					'BD-37' => 'Magura',
					'BD-33' => 'Manikganj ',
					'BD-39' => 'Meherpur',
					'BD-38' => 'Moulvibazar',
					'BD-35' => 'Munshiganj',
					'BD-34' => 'Mymensingh',
					'BD-48' => 'Naogaon',
					'BD-43' => 'Narail',
					'BD-40' => 'Narayanganj',
					'BD-42' => 'Narsingdi',
					'BD-44' => 'Natore',
					'BD-45' => 'Nawabganj',
					'BD-41' => 'Netrakona',
					'BD-46' => 'Nilphamari',
					'BD-47' => 'Noakhali',
					'BD-49' => 'Pabna',
					'BD-52' => 'Panchagarh',
					'BD-51' => 'Patuakhali',
					'BD-50' => 'Pirojpur',
					'BD-53' => 'Rajbari',
					'BD-54' => 'Rajshahi',
					'BD-56' => 'Rangamati',
					'BD-55' => 'Rangpur',
					'BD-58' => 'Satkhira',
					'BD-62' => 'Shariatpur',
					'BD-57' => 'Sherpur',
					'BD-59' => 'Sirajganj',
					'BD-61' => 'Sunamganj',
					'BD-60' => 'Sylhet',
					'BD-63' => 'Tangail',
					'BD-64' => 'Thakurgaon',
				),
		),
	'BB' =>
		array (
			'info' =>
				array (
					'name' => 'Barbados',
					'phone_code' => '+1246',
				),
			'currency' =>
				array (
					'code' => 'BBD',
					'symbol' => 'Bds$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BY' =>
		array (
			'info' =>
				array (
					'name' => 'Belarus',
					'phone_code' => '+375',
				),
			'currency' =>
				array (
					'code' => 'BYN',
					'symbol' => 'Br',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BE' =>
		array (
			'info' =>
				array (
					'name' => 'Belgium',
					'phone_code' => '+32',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ' ',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'BE',
											'state' => '',
											'rate' => '21.0000',
											'name' => 'BTW',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'PW' =>
		array (
			'info' =>
				array (
					'name' => 'Belau', #Palau
					'phone_code' => '+680',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BZ' =>
		array (
			'info' =>
				array (
					'name' => 'Belize',
					'phone_code' => '+501',
				),
			'currency' =>
				array (
					'code' => 'BZD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BJ' =>
		array (
			'info' =>
				array (
					'name' => 'Benin',
					'phone_code' => '+229',
				),
			'currency' =>
				array (
					'code' => 'XOF',
					'symbol' => 'CFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BM' =>
		array (
			'info' =>
				array (
					'name' => 'Bermuda',
					'phone_code' => '+1441',
				),
			'currency' =>
				array (
					'code' => 'BMD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BT' =>
		array (
			'info' =>
				array (
					'name' => 'Bhutan',
					'phone_code' => '+975',
				),
			'currency' =>
				array (
					'code' => 'BTN',
					'symbol' => 'Nu',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BO' =>
		array (
			'info' =>
				array (
					'name' => 'Bolivia',
					'phone_code' => '+591',
				),
			'currency' =>
				array (
					'code' => 'BOB',
					'symbol' => 'Bs',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'B' => 'Chuquisaca',
					'H' => 'Beni',
					'C' => 'Cochabamba',
					'L' => 'La Paz',
					'O' => 'Oruro',
					'N' => 'Pando',
					'P' => 'Potosí',
					'S' => 'Santa Cruz',
					'T' => 'Tarija',
				),
		),
	'BQ' =>
		array (
			'info' =>
				array (
					'name' => 'Bonaire, Saint Eustatius and Saba',
					'phone_code' => '+599',
				),
			'currency' =>
				array (
					'code' => 'ANG',
					'symbol' => 'NAƒ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BA' =>
		array (
			'info' =>
				array (
					'name' => 'Bosnia and Herzegovina',
					'phone_code' => '+387',
				),
			'currency' =>
				array (
					'code' => 'BAM',
					'symbol' => 'KM',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BW' =>
		array (
			'info' =>
				array (
					'name' => 'Botswana',
					'phone_code' => '+267',
				),
			'currency' =>
				array (
					'code' => 'BWP',
					'symbol' => 'P',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BV' =>
		array (
			'info' =>
				array (
					'name' => 'Bouvet Island',
					'phone_code' => '',
				),
			'currency' =>
				array (
					'code' => 'NOK',
					'symbol' => 'kr',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BR' =>
		array (
			'info' =>
				array (
					'name' => 'Brazil',
					'phone_code' => '+55',
				),
			'currency' =>
				array (
					'code' => 'BRL',
					'symbol' => 'R$',
					'currency_pos' => 'left',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'AC' => 'Acre',
					'AL' => 'Alagoas',
					'AP' => 'Amap&aacute;',
					'AM' => 'Amazonas',
					'BA' => 'Bahia',
					'CE' => 'Cear&aacute;',
					'DF' => 'Distrito Federal',
					'ES' => 'Esp&iacute;rito Santo',
					'GO' => 'Goi&aacute;s',
					'MA' => 'Maranh&atilde;o',
					'MT' => 'Mato Grosso',
					'MS' => 'Mato Grosso do Sul',
					'MG' => 'Minas Gerais',
					'PA' => 'Par&aacute;',
					'PB' => 'Para&iacute;ba',
					'PR' => 'Paran&aacute;',
					'PE' => 'Pernambuco',
					'PI' => 'Piau&iacute;',
					'RJ' => 'Rio de Janeiro',
					'RN' => 'Rio Grande do Norte',
					'RS' => 'Rio Grande do Sul',
					'RO' => 'Rond&ocirc;nia',
					'RR' => 'Roraima',
					'SC' => 'Santa Catarina',
					'SP' => 'S&atilde;o Paulo',
					'SE' => 'Sergipe',
					'TO' => 'Tocantins',
				),
		),
	'IO' =>
		array (
			'info' =>
				array (
					'name' => 'British Indian Ocean Territory',
					'phone_code' => '+246',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BN' =>
		array (
			'info' =>
				array (
					'name' => 'Brunei',
					'phone_code' => '+673',
				),
			'currency' =>
				array (
					'code' => 'BND',
					'symbol' => 'B$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BG' =>
		array (
			'info' =>
				array (
					'name' => 'Bulgaria',
					'phone_code' => '+359',
				),
			'currency' =>
				array (
					'code' => 'BGN',
					'symbol' => 'Лв',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'BG-01' => 'Blagoevgrad',
					'BG-02' => 'Burgas',
					'BG-08' => 'Dobrich',
					'BG-07' => 'Gabrovo',
					'BG-26' => 'Haskovo',
					'BG-09' => 'Kardzhali',
					'BG-10' => 'Kyustendil',
					'BG-11' => 'Lovech',
					'BG-12' => 'Montana',
					'BG-13' => 'Pazardzhik',
					'BG-14' => 'Pernik',
					'BG-15' => 'Pleven',
					'BG-16' => 'Plovdiv',
					'BG-17' => 'Razgrad',
					'BG-18' => 'Ruse',
					'BG-27' => 'Shumen',
					'BG-19' => 'Silistra',
					'BG-20' => 'Sliven',
					'BG-21' => 'Smolyan',
					'BG-23' => 'Sofia',
					'BG-22' => 'Sofia-Grad',
					'BG-24' => 'Stara Zagora',
					'BG-25' => 'Targovishte',
					'BG-03' => 'Varna',
					'BG-04' => 'Veliko Tarnovo',
					'BG-05' => 'Vidin',
					'BG-06' => 'Vratsa',
					'BG-28' => 'Yambol',
				),
		),
	'BF' =>
		array (
			'info' =>
				array (
					'name' => 'Burkina Faso',
					'phone_code' => '+226',
				),
			'currency' =>
				array (
					'code' => 'XOF',
					'symbol' => 'CFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BI' =>
		array (
			'info' =>
				array (
					'name' => 'Burundi',
					'phone_code' => '+257',
				),
			'currency' =>
				array (
					'code' => 'BIF',
					'symbol' => 'FBu',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KH' =>
		array (
			'info' =>
				array (
					'name' => 'Cambodia',
					'phone_code' => '+855',
				),
			'currency' =>
				array (
					'code' => 'KHR',
					'symbol' => '៛',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CM' =>
		array (
			'info' =>
				array (
					'name' => 'Cameroon',
					'phone_code' => '+237',
				),
			'currency' =>
				array (
					'code' => 'XAF',
					'symbol' => 'FCFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CA' =>
		array (
			'info' =>
				array (
					'name' => 'Canada',
					'phone_code' => '+1',
				),
			'currency' =>
				array (
					'code' => 'CAD',
					'symbol' => 'CA$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'BC' =>
								array (
									0 =>
										array (
											'country' => 'CA',
											'state' => 'BC',
											'rate' => '7.0000',
											'name' => 'PST',
											'shipping' => false,
											'priority' => 2,
										),
								),
							'SK' =>
								array (
									0 =>
										array (
											'country' => 'CA',
											'state' => 'SK',
											'rate' => '5.0000',
											'name' => 'PST',
											'shipping' => false,
											'priority' => 2,
										),
								),
							'MB' =>
								array (
									0 =>
										array (
											'country' => 'CA',
											'state' => 'MB',
											'rate' => '8.0000',
											'name' => 'PST',
											'shipping' => false,
											'priority' => 2,
										),
								),
							'QC' =>
								array (
									0 =>
										array (
											'country' => 'CA',
											'state' => 'QC',
											'rate' => '9.975',
											'name' => 'QST',
											'shipping' => false,
											'priority' => 2,
										),
								),
							'*' =>
								array (
									0 =>
										array (
											'country' => 'CA',
											'state' => 'ON',
											'rate' => '13.0000',
											'name' => 'HST',
											'shipping' => true,
										),
									1 =>
										array (
											'country' => 'CA',
											'state' => 'NL',
											'rate' => '13.0000',
											'name' => 'HST',
											'shipping' => true,
										),
									2 =>
										array (
											'country' => 'CA',
											'state' => 'NB',
											'rate' => '13.0000',
											'name' => 'HST',
											'shipping' => true,
										),
									3 =>
										array (
											'country' => 'CA',
											'state' => 'PE',
											'rate' => '14.0000',
											'name' => 'HST',
											'shipping' => true,
										),
									4 =>
										array (
											'country' => 'CA',
											'state' => 'NS',
											'rate' => '15.0000',
											'name' => 'HST',
											'shipping' => true,
										),
									5 =>
										array (
											'country' => 'CA',
											'state' => 'AB',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
									6 =>
										array (
											'country' => 'CA',
											'state' => 'BC',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
									7 =>
										array (
											'country' => 'CA',
											'state' => 'NT',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
									8 =>
										array (
											'country' => 'CA',
											'state' => 'NU',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
									9 =>
										array (
											'country' => 'CA',
											'state' => 'YT',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
									10 =>
										array (
											'country' => 'CA',
											'state' => 'SK',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
									11 =>
										array (
											'country' => 'CA',
											'state' => 'MB',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
									12 =>
										array (
											'country' => 'CA',
											'state' => 'QC',
											'rate' => '5.0000',
											'name' => 'GST',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'AB' => 'Alberta',
					'BC' => 'British Columbia',
					'MB' => 'Manitoba',
					'NB' => 'New Brunswick',
					'NL' => 'Newfoundland and Labrador',
					'NT' => 'Northwest Territories',
					'NS' => 'Nova Scotia',
					'NU' => 'Nunavut',
					'ON' => 'Ontario',
					'PE' => 'Prince Edward Island',
					'QC' => 'Quebec',
					'SK' => 'Saskatchewan',
					'YT' => 'Yukon Territory',
				),
		),
	'CV' =>
		array (
			'info' =>
				array (
					'name' => 'Cape Verde',
					'phone_code' => '+238',
				),
			'currency' =>
				array (
					'code' => 'CVE',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KY' =>
		array (
			'info' =>
				array (
					'name' => 'Cayman Islands',
					'phone_code' => '+1345',
				),
			'currency' =>
				array (
					'code' => 'KYD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CF' =>
		array (
			'info' =>
				array (
					'name' => 'Central African Republic',
					'phone_code' => '+236',
				),
			'currency' =>
				array (
					'code' => 'XAF',
					'symbol' => 'FCFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TD' =>
		array (
			'info' =>
				array (
					'name' => 'Chad',
					'phone_code' => '+235',
				),
			'currency' =>
				array (
					'code' => 'XAF',
					'symbol' => 'FCFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CL' =>
		array (
			'info' =>
				array (
					'name' => 'Chile',
					'phone_code' => '+56',
				),
			'currency' =>
				array (
					'code' => 'CLP',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CN' =>
		array (
			'info' =>
				array (
					'name' => 'China',
					'phone_code' => '+86',
				),
			'currency' =>
				array (
					'code' => 'CNY',
					'symbol' => '¥',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'CN1' => 'Yunnan / &#20113;&#21335;',
					'CN2' => 'Beijing / &#21271;&#20140;',
					'CN3' => 'Tianjin / &#22825;&#27941;',
					'CN4' => 'Hebei / &#27827;&#21271;',
					'CN5' => 'Shanxi / &#23665;&#35199;',
					'CN6' => 'Inner Mongolia / &#20839;&#33945;&#21476;',
					'CN7' => 'Liaoning / &#36797;&#23425;',
					'CN8' => 'Jilin / &#21513;&#26519;',
					'CN9' => 'Heilongjiang / &#40657;&#40857;&#27743;',
					'CN10' => 'Shanghai / &#19978;&#28023;',
					'CN11' => 'Jiangsu / &#27743;&#33487;',
					'CN12' => 'Zhejiang / &#27993;&#27743;',
					'CN13' => 'Anhui / &#23433;&#24509;',
					'CN14' => 'Fujian / &#31119;&#24314;',
					'CN15' => 'Jiangxi / &#27743;&#35199;',
					'CN16' => 'Shandong / &#23665;&#19996;',
					'CN17' => 'Henan / &#27827;&#21335;',
					'CN18' => 'Hubei / &#28246;&#21271;',
					'CN19' => 'Hunan / &#28246;&#21335;',
					'CN20' => 'Guangdong / &#24191;&#19996;',
					'CN21' => 'Guangxi Zhuang / &#24191;&#35199;&#22766;&#26063;',
					'CN22' => 'Hainan / &#28023;&#21335;',
					'CN23' => 'Chongqing / &#37325;&#24198;',
					'CN24' => 'Sichuan / &#22235;&#24029;',
					'CN25' => 'Guizhou / &#36149;&#24030;',
					'CN26' => 'Shaanxi / &#38485;&#35199;',
					'CN27' => 'Gansu / &#29976;&#32899;',
					'CN28' => 'Qinghai / &#38738;&#28023;',
					'CN29' => 'Ningxia Hui / &#23425;&#22799;',
					'CN30' => 'Macau / &#28595;&#38376;',
					'CN31' => 'Tibet / &#35199;&#34255;',
					'CN32' => 'Xinjiang / &#26032;&#30086;',
				),
		),
	'CX' =>
		array (
			'info' =>
				array (
					'name' => 'Christmas Island',
					'phone_code' => '+61',
				),
			'currency' =>
				array (
					'code' => 'AUD',
					'symbol' => 'A$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CC' =>
		array (
			'info' =>
				array (
					'name' => 'Cocos (Keeling) Islands',
					'phone_code' => '+61',
				),
			'currency' =>
				array (
					'code' => 'AUD',
					'symbol' => 'A$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CO' =>
		array (
			'info' =>
				array (
					'name' => 'Colombia',
					'phone_code' => '+57',
				),
			'currency' =>
				array (
					'code' => 'COP',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KM' =>
		array (
			'info' =>
				array (
					'name' => 'Comoros',
					'phone_code' => '+269',
				),
			'currency' =>
				array (
					'code' => 'KMF',
					'symbol' => 'CF',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CG' =>
		array (
			'info' =>
				array (
					'name' => 'Congo (Brazzaville)',
					'phone_code' => '+242',
				),
			'currency' =>
				array (
					'code' => 'XAF',
					'symbol' => 'FCFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CD' =>
		array (
			'info' =>
				array (
					'name' => 'Congo (Kinshasa)',
					'phone_code' => '+243',
				),
			'currency' =>
				array (
					'code' => 'CDF',
					'symbol' => 'FC',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CK' =>
		array (
			'info' =>
				array (
					'name' => 'Cook Islands',
					'phone_code' => '+682',
				),
			'currency' =>
				array (
					'code' => 'NZD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CR' =>
		array (
			'info' =>
				array (
					'name' => 'Costa Rica',
					'phone_code' => '+506',
				),
			'currency' =>
				array (
					'code' => 'CRC',
					'symbol' => '₡',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'HR' =>
		array (
			'info' =>
				array (
					'name' => 'Croatia',
					'phone_code' => '+385',
				),
			'currency' =>
				array (
					'code' => 'HRK',
					'symbol' => 'kn',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CU' =>
		array (
			'info' =>
				array (
					'name' => 'Cuba',
					'phone_code' => '+53',
				),
			'currency' =>
				array (
					'code' => 'CUP',
					'symbol' => '₱',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CW' =>
		array (
			'info' =>
				array (
					'name' => 'Cura&ccedil;ao',
					'phone_code' => '+599',
				),
			'currency' =>
				array (
					'code' => 'ANG',
					'symbol' => 'NAƒ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CY' =>
		array (
			'info' =>
				array (
					'name' => 'Cyprus',
					'phone_code' => '+357',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CZ' =>
		array (
			'info' =>
				array (
					'name' => 'Czech Republic',
					'phone_code' => '+420',
				),
			'currency' =>
				array (
					'code' => 'CZK',
					'symbol' => 'Kč',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'DK' =>
		array (
			'info' =>
				array (
					'name' => 'Denmark',
					'phone_code' => '+45',
				),
			'currency' =>
				array (
					'code' => 'DKK',
					'symbol' => 'kr',
					'currency_pos' => 'left_space',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => '*',
											'state' => '',
											'rate' => '25.0000',
											'name' => 'Moms',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'DJ' =>
		array (
			'info' =>
				array (
					'name' => 'Djibouti',
					'phone_code' => '+253',
				),
			'currency' =>
				array (
					'code' => 'DJF',
					'symbol' => 'Fdj',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'DM' =>
		array (
			'info' =>
				array (
					'name' => 'Dominica',
					'phone_code' => '+1767',
				),
			'currency' =>
				array (
					'code' => 'DOP',
					'symbol' => 'RD$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'DO' =>
		array (
			'info' =>
				array (
					'name' => 'Dominican Republic',
					'phone_code' =>
						array (
							0 => '+1809',
							1 => '+1829',
							2 => '+1849',
						),
				),
			'currency' =>
				array (
					'code' => 'DOP',
					'symbol' => 'RD$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'EC' =>
		array (
			'info' =>
				array (
					'name' => 'Ecuador',
					'phone_code' => '+593',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'EG' =>
		array (
			'info' =>
				array (
					'name' => 'Egypt',
					'phone_code' => '+20',
				),
			'currency' =>
				array (
					'code' => 'EGP',
					'symbol' => 'E£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SV' =>
		array (
			'info' =>
				array (
					'name' => 'El Salvador',
					'phone_code' => '+503',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GQ' =>
		array (
			'info' =>
				array (
					'name' => 'Equatorial Guinea',
					'phone_code' => '+240',
				),
			'currency' =>
				array (
					'code' => 'XAF',
					'symbol' => 'FCFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ER' =>
		array (
			'info' =>
				array (
					'name' => 'Eritrea',
					'phone_code' => '+291',
				),
			'currency' =>
				array (
					'code' => 'ERN',
					'symbol' => 'Nfk',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'EE' =>
		array (
			'info' =>
				array (
					'name' => 'Estonia',
					'phone_code' => '+372',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ET' =>
		array (
			'info' =>
				array (
					'name' => 'Ethiopia',
					'phone_code' => '+251',
				),
			'currency' =>
				array (
					'code' => 'ETB',
					'symbol' => 'Br',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'FK' =>
		array (
			'info' =>
				array (
					'name' => 'Falkland Islands',
					'phone_code' => '+500',
				),
			'currency' =>
				array (
					'code' => 'FKP',
					'symbol' => '£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'FO' =>
		array (
			'info' =>
				array (
					'name' => 'Faroe Islands',
					'phone_code' => '+298',
				),
			'currency' =>
				array (
					'code' => 'FOK',
					'symbol' => 'kr',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'FJ' =>
		array (
			'info' =>
				array (
					'name' => 'Fiji',
					'phone_code' => '+679',
				),
			'currency' =>
				array (
					'code' => 'FJD',
					'symbol' => '‎FJ$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'FI' =>
		array (
			'info' =>
				array (
					'name' => 'Finland',
					'phone_code' => '+358',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'right_space',
					'thousand' => ' ',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'FI',
											'state' => '',
											'rate' => '24.0000',
											'name' => 'ALV',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'FR' =>
		array (
			'info' =>
				array (
					'name' => 'France',
					'phone_code' => '+33',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'right',
					'thousand' => ' ',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'FR',
											'state' => '',
											'rate' => '20.0000',
											'name' => 'TVA',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'GF' =>
		array (
			'info' =>
				array (
					'name' => 'French Guiana',
					'phone_code' => '+594',
				),
			'currency' =>
				array (
					'code' => 'GNF',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PF' =>
		array (
			'info' =>
				array (
					'name' => 'French Polynesia',
					'phone_code' => '+689',
				),
			'currency' =>
				array (
					'code' => 'XPF',
					'symbol' => '₣',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TF' =>
		array (
			'info' =>
				array (
					'name' => 'French Southern Territories',
					'phone_code' => '',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GA' =>
		array (
			'info' =>
				array (
					'name' => 'Gabon',
					'phone_code' => '+241',
				),
			'currency' =>
				array (
					'code' => 'XAF',
					'symbol' => 'FCFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GM' =>
		array (
			'info' =>
				array (
					'name' => 'Gambia',
					'phone_code' => '+220',
				),
			'currency' =>
				array (
					'code' => 'GMD',
					'symbol' => 'D',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GE' =>
		array (
			'info' =>
				array (
					'name' => 'Georgia',
					'phone_code' => '+995',
				),
			'currency' =>
				array (
					'code' => 'GEL',
					'symbol' => 'ლ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'DE' =>
		array (
			'info' =>
				array (
					'name' => 'Germany',
					'phone_code' => '+49',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'DE',
											'state' => '',
											'rate' => '19.0000',
											'name' => 'Mwst.',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'GH' =>
		array (
			'info' =>
				array (
					'name' => 'Ghana',
					'phone_code' => '+233',
				),
			'currency' =>
				array (
					'code' => 'GHS',
					'symbol' => '₵',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GI' =>
		array (
			'info' =>
				array (
					'name' => 'Gibraltar',
					'phone_code' => '+350',
				),
			'currency' =>
				array (
					'code' => 'GIP',
					'symbol' => '£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GR' =>
		array (
			'info' =>
				array (
					'name' => 'Greece',
					'phone_code' => '+30',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'I' => 'Αττική',
					'A' => 'Ανατολική Μακεδονία και Θράκη',
					'B' => 'Κεντρική Μακεδονία',
					'C' => 'Δυτική Μακεδονία',
					'D' => 'Ήπειρος',
					'E' => 'Θεσσαλία',
					'F' => 'Ιόνιοι Νήσοι',
					'G' => 'Δυτική Ελλάδα',
					'H' => 'Στερεά Ελλάδα',
					'J' => 'Πελοπόννησος',
					'K' => 'Βόρειο Αιγαίο',
					'L' => 'Νότιο Αιγαίο',
					'M' => 'Κρήτη',
				),
		),
	'GL' =>
		array (
			'info' =>
				array (
					'name' => 'Greenland',
					'phone_code' => '+299',
				),
			'currency' =>
				array (
					'code' => 'DKK',
					'symbol' => 'kr',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GD' =>
		array (
			'info' =>
				array (
					'name' => 'Grenada',
					'phone_code' => '+1473',
				),
			'currency' =>
				array (
					'code' => 'XCD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GP' =>
		array (
			'info' =>
				array (
					'name' => 'Guadeloupe',
					'phone_code' => '+590',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GU' =>
		array (
			'info' =>
				array (
					'name' => 'Guam',
					'phone_code' => '+1671',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GT' =>
		array (
			'info' =>
				array (
					'name' => 'Guatemala',
					'phone_code' => '+502',
				),
			'currency' =>
				array (
					'code' => 'GTQ',
					'symbol' => 'Q',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GG' =>
		array (
			'info' =>
				array (
					'name' => 'Guernsey',
					'phone_code' => '+441481',
				),
			'currency' =>
				array (
					'code' => 'GGP',
					'symbol' => '£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GN' =>
		array (
			'info' =>
				array (
					'name' => 'Guinea',
					'phone_code' => '+224',
				),
			'currency' =>
				array (
					'code' => 'GNF',
					'symbol' => 'Fr',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GW' =>
		array (
			'info' =>
				array (
					'name' => 'Guinea-Bissau',
					'phone_code' => '+245',
				),
			'currency' =>
				array (
					'code' => 'XOF',
					'symbol' => 'CFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GY' =>
		array (
			'info' =>
				array (
					'name' => 'Guyana',
					'phone_code' => '+592',
				),
			'currency' =>
				array (
					'code' => 'GYD',
					'symbol' => 'GY$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'HT' =>
		array (
			'info' =>
				array (
					'name' => 'Haiti',
					'phone_code' => '+509',
				),
			'currency' =>
				array (
					'code' => 'HTG',
					'symbol' => 'G',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'HM' =>
		array (
			'info' =>
				array (
					'name' => 'Heard Island and McDonald Islands',
					'phone_code' => '',
				),
			'currency' =>
				array (
					'code' => 'AUD',
					'symbol' => 'A$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'HN' =>
		array (
			'info' =>
				array (
					'name' => 'Honduras',
					'phone_code' => '+504',
				),
			'currency' =>
				array (
					'code' => 'HNL',
					'symbol' => 'L',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'HK' =>
		array (
			'info' =>
				array (
					'name' => 'Hong Kong',
					'phone_code' => '+852',
				),
			'currency' =>
				array (
					'code' => 'HKD',
					'symbol' => 'HK$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'HONG KONG' => 'Hong Kong Island',
					'KOWLOON' => 'Kowloon',
					'NEW TERRITORIES' => 'New Territories',
				),
		),
	'HU' =>
		array (
			'info' =>
				array (
					'name' => 'Hungary',
					'phone_code' => '+36',
				),
			'currency' =>
				array (
					'code' => 'HUF',
					'symbol' => 'Ft',
					'currency_pos' => 'right_space',
					'thousand' => ' ',
					'decimal' => ',',
					'num_decimals' => 0,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'HU',
											'state' => '',
											'rate' => '27.0000',
											'name' => 'ÁFA',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'BK' => 'Bács-Kiskun',
					'BE' => 'Békés',
					'BA' => 'Baranya',
					'BZ' => 'Borsod-Abaúj-Zemplén',
					'BU' => 'Budapest',
					'CS' => 'Csongrád',
					'FE' => 'Fejér',
					'GS' => 'Győr-Moson-Sopron',
					'HB' => 'Hajdú-Bihar',
					'HE' => 'Heves',
					'JN' => 'Jász-Nagykun-Szolnok',
					'KE' => 'Komárom-Esztergom',
					'NO' => 'Nógrád',
					'PE' => 'Pest',
					'SO' => 'Somogy',
					'SZ' => 'Szabolcs-Szatmár-Bereg',
					'TO' => 'Tolna',
					'VA' => 'Vas',
					'VE' => 'Veszprém',
					'ZA' => 'Zala',
				),
		),
	'IS' =>
		array (
			'info' =>
				array (
					'name' => 'Iceland',
					'phone_code' => '+354',
				),
			'currency' =>
				array (
					'code' => 'ISK',
					'symbol' => 'kr',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'IN' =>
		array (
			'info' =>
				array (
					'name' => 'India',
					'phone_code' => '+91',
				),
			'currency' =>
				array (
					'code' => 'INR',
					'symbol' => '₹',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'IN',
											'state' => '',
											'rate' => '15.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'AP' => 'Andhra Pradesh',
					'AR' => 'Arunachal Pradesh',
					'AS' => 'Assam',
					'BR' => 'Bihar',
					'CT' => 'Chhattisgarh',
					'GA' => 'Goa',
					'GJ' => 'Gujarat',
					'HR' => 'Haryana',
					'HP' => 'Himachal Pradesh',
					'JK' => 'Jammu and Kashmir',
					'JH' => 'Jharkhand',
					'KA' => 'Karnataka',
					'KL' => 'Kerala',
					'MP' => 'Madhya Pradesh',
					'MH' => 'Maharashtra',
					'MN' => 'Manipur',
					'ML' => 'Meghalaya',
					'MZ' => 'Mizoram',
					'NL' => 'Nagaland',
					'OR' => 'Orissa',
					'PB' => 'Punjab',
					'RJ' => 'Rajasthan',
					'SK' => 'Sikkim',
					'TN' => 'Tamil Nadu',
					'TS' => 'Telangana',
					'TR' => 'Tripura',
					'UK' => 'Uttarakhand',
					'UP' => 'Uttar Pradesh',
					'WB' => 'West Bengal',
					'AN' => 'Andaman and Nicobar Islands',
					'CH' => 'Chandigarh',
					'DN' => 'Dadra and Nagar Haveli',
					'DD' => 'Daman and Diu',
					'DL' => 'Delhi',
					'LD' => 'Lakshadeep',
					'PY' => 'Pondicherry (Puducherry)',
				),
		),
	'ID' =>
		array (
			'info' =>
				array (
					'name' => 'Indonesia',
					'phone_code' => '+62',
				),
			'currency' =>
				array (
					'code' => 'IDR',
					'symbol' => 'Rp',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'AC' => 'Daerah Istimewa Aceh',
					'SU' => 'Sumatera Utara',
					'SB' => 'Sumatera Barat',
					'RI' => 'Riau',
					'KR' => 'Kepulauan Riau',
					'JA' => 'Jambi',
					'SS' => 'Sumatera Selatan',
					'BB' => 'Bangka Belitung',
					'BE' => 'Bengkulu',
					'LA' => 'Lampung',
					'JK' => 'DKI Jakarta',
					'JB' => 'Jawa Barat',
					'BT' => 'Banten',
					'JT' => 'Jawa Tengah',
					'JI' => 'Jawa Timur',
					'YO' => 'Daerah Istimewa Yogyakarta',
					'BA' => 'Bali',
					'NB' => 'Nusa Tenggara Barat',
					'NT' => 'Nusa Tenggara Timur',
					'KB' => 'Kalimantan Barat',
					'KT' => 'Kalimantan Tengah',
					'KI' => 'Kalimantan Timur',
					'KS' => 'Kalimantan Selatan',
					'KU' => 'Kalimantan Utara',
					'SA' => 'Sulawesi Utara',
					'ST' => 'Sulawesi Tengah',
					'SG' => 'Sulawesi Tenggara',
					'SR' => 'Sulawesi Barat',
					'SN' => 'Sulawesi Selatan',
					'GO' => 'Gorontalo',
					'MA' => 'Maluku',
					'MU' => 'Maluku Utara',
					'PA' => 'Papua',
					'PB' => 'Papua Barat',
				),
		),
	'IR' =>
		array (
			'info' =>
				array (
					'name' => 'Iran',
					'phone_code' => '+98',
				),
			'currency' =>
				array (
					'code' => 'IRR',
					'symbol' => '﷼',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'KHZ' => 'Khuzestan  (خوزستان)',
					'THR' => 'Tehran  (تهران)',
					'ILM' => 'Ilaam (ایلام)',
					'BHR' => 'Bushehr (بوشهر)',
					'ADL' => 'Ardabil (اردبیل)',
					'ESF' => 'Isfahan (اصفهان)',
					'YZD' => 'Yazd (یزد)',
					'KRH' => 'Kermanshah (کرمانشاه)',
					'KRN' => 'Kerman (کرمان)',
					'HDN' => 'Hamadan (همدان)',
					'GZN' => 'Ghazvin (قزوین)',
					'ZJN' => 'Zanjan (زنجان)',
					'LRS' => 'Luristan (لرستان)',
					'ABZ' => 'Alborz (البرز)',
					'EAZ' => 'East Azarbaijan (آذربایجان شرقی)',
					'WAZ' => 'West Azarbaijan (آذربایجان غربی)',
					'CHB' => 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)',
					'SKH' => 'South Khorasan (خراسان جنوبی)',
					'RKH' => 'Razavi Khorasan (خراسان رضوی)',
					'NKH' => 'North Khorasan (خراسان شمالی)',
					'SMN' => 'Semnan (سمنان)',
					'FRS' => 'Fars (فارس)',
					'QHM' => 'Qom (قم)',
					'KRD' => 'Kurdistan / کردستان)',
					'KBD' => 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)',
					'GLS' => 'Golestan (گلستان)',
					'GIL' => 'Gilan (گیلان)',
					'MZN' => 'Mazandaran (مازندران)',
					'MKZ' => 'Markazi (مرکزی)',
					'HRZ' => 'Hormozgan (هرمزگان)',
					'SBN' => 'Sistan and Baluchestan (سیستان و بلوچستان)',
				),
		),
	'IQ' =>
		array (
			'info' =>
				array (
					'name' => 'Iraq',
					'phone_code' => '+964',
				),
			'currency' =>
				array (
					'code' => 'IQD',
					'symbol' => 'ع.د',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'IE' =>
		array (
			'info' =>
				array (
					'name' => 'Ireland',
					'phone_code' => '+353',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'CW' => 'Carlow',
					'CN' => 'Cavan',
					'CE' => 'Clare',
					'CO' => 'Cork',
					'DL' => 'Donegal',
					'D' => 'Dublin',
					'G' => 'Galway',
					'KY' => 'Kerry',
					'KE' => 'Kildare',
					'KK' => 'Kilkenny',
					'LS' => 'Laois',
					'LM' => 'Leitrim',
					'LK' => 'Limerick',
					'LD' => 'Longford',
					'LH' => 'Louth',
					'MO' => 'Mayo',
					'MH' => 'Meath',
					'MN' => 'Monaghan',
					'OY' => 'Offaly',
					'RN' => 'Roscommon',
					'SO' => 'Sligo',
					'TA' => 'Tipperary',
					'WD' => 'Waterford',
					'WH' => 'Westmeath',
					'WX' => 'Wexford',
					'WW' => 'Wicklow',
				),
		),
	'IM' =>
		array (
			'info' =>
				array (
					'name' => 'Isle of Man',
					'phone_code' => '+441624',
				),
			'currency' =>
				array (
					'code' => 'IMP',
					'symbol' => '‎£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'IL' =>
		array (
			'info' =>
				array (
					'name' => 'Israel',
					'phone_code' => '+972',
				),
			'currency' =>
				array (
					'code' => 'Shekel',
					'symbol' => '&#8362;',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'IT' =>
		array (
			'info' =>
				array (
					'name' => 'Italy',
					'phone_code' => '+39',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'right',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'IT',
											'state' => '',
											'rate' => '22.0000',
											'name' => 'IVA',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'AG' => 'Agrigento',
					'AL' => 'Alessandria',
					'AN' => 'Ancona',
					'AO' => 'Aosta',
					'AR' => 'Arezzo',
					'AP' => 'Ascoli Piceno',
					'AT' => 'Asti',
					'AV' => 'Avellino',
					'BA' => 'Bari',
					'BT' => 'Barletta-Andria-Trani',
					'BL' => 'Belluno',
					'BN' => 'Benevento',
					'BG' => 'Bergamo',
					'BI' => 'Biella',
					'BO' => 'Bologna',
					'BZ' => 'Bolzano',
					'BS' => 'Brescia',
					'BR' => 'Brindisi',
					'CA' => 'Cagliari',
					'CL' => 'Caltanissetta',
					'CB' => 'Campobasso',
					'CE' => 'Caserta',
					'CT' => 'Catania',
					'CZ' => 'Catanzaro',
					'CH' => 'Chieti',
					'CO' => 'Como',
					'CS' => 'Cosenza',
					'CR' => 'Cremona',
					'KR' => 'Crotone',
					'CN' => 'Cuneo',
					'EN' => 'Enna',
					'FM' => 'Fermo',
					'FE' => 'Ferrara',
					'FI' => 'Firenze',
					'FG' => 'Foggia',
					'FC' => 'Forlì-Cesena',
					'FR' => 'Frosinone',
					'GE' => 'Genova',
					'GO' => 'Gorizia',
					'GR' => 'Grosseto',
					'IM' => 'Imperia',
					'IS' => 'Isernia',
					'SP' => 'La Spezia',
					'AQ' => 'L\'Aquila',
					'LT' => 'Latina',
					'LE' => 'Lecce',
					'LC' => 'Lecco',
					'LI' => 'Livorno',
					'LO' => 'Lodi',
					'LU' => 'Lucca',
					'MC' => 'Macerata',
					'MN' => 'Mantova',
					'MS' => 'Massa-Carrara',
					'MT' => 'Matera',
					'ME' => 'Messina',
					'MI' => 'Milano',
					'MO' => 'Modena',
					'MB' => 'Monza e della Brianza',
					'NA' => 'Napoli',
					'NO' => 'Novara',
					'NU' => 'Nuoro',
					'OR' => 'Oristano',
					'PD' => 'Padova',
					'PA' => 'Palermo',
					'PR' => 'Parma',
					'PV' => 'Pavia',
					'PG' => 'Perugia',
					'PU' => 'Pesaro e Urbino',
					'PE' => 'Pescara',
					'PC' => 'Piacenza',
					'PI' => 'Pisa',
					'PT' => 'Pistoia',
					'PN' => 'Pordenone',
					'PZ' => 'Potenza',
					'PO' => 'Prato',
					'RG' => 'Ragusa',
					'RA' => 'Ravenna',
					'RC' => 'Reggio Calabria',
					'RE' => 'Reggio Emilia',
					'RI' => 'Rieti',
					'RN' => 'Rimini',
					'RM' => 'Roma',
					'RO' => 'Rovigo',
					'SA' => 'Salerno',
					'SS' => 'Sassari',
					'SV' => 'Savona',
					'SI' => 'Siena',
					'SR' => 'Siracusa',
					'SO' => 'Sondrio',
					'SU' => 'Sud Sardegna',
					'TA' => 'Taranto',
					'TE' => 'Teramo',
					'TR' => 'Terni',
					'TO' => 'Torino',
					'TP' => 'Trapani',
					'TN' => 'Trento',
					'TV' => 'Treviso',
					'TS' => 'Trieste',
					'UD' => 'Udine',
					'VA' => 'Varese',
					'VE' => 'Venezia',
					'VB' => 'Verbano-Cusio-Ossola',
					'VC' => 'Vercelli',
					'VR' => 'Verona',
					'VV' => 'Vibo Valentia',
					'VI' => 'Vicenza',
					'VT' => 'Viterbo',
				),
		),
	'JM' =>
		array (
			'info' =>
				array (
					'name' => 'Jamaica',
					'phone_code' => '+1876',
				),
			'currency' =>
				array (
					'code' => 'JMD',
					'symbol' => 'JA$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'JP' =>
		array (
			'info' =>
				array (
					'name' => 'Japan',
					'phone_code' => '+81',
				),
			'currency' =>
				array (
					'code' => 'JPY',
					'symbol' => '¥',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 0,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'JP',
											'state' => '',
											'rate' => '8.0000',
											'name' => 'Consumption tax',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'JP01' => 'Hokkaido',
					'JP02' => 'Aomori',
					'JP03' => 'Iwate',
					'JP04' => 'Miyagi',
					'JP05' => 'Akita',
					'JP06' => 'Yamagata',
					'JP07' => 'Fukushima',
					'JP08' => 'Ibaraki',
					'JP09' => 'Tochigi',
					'JP10' => 'Gunma',
					'JP11' => 'Saitama',
					'JP12' => 'Chiba',
					'JP13' => 'Tokyo',
					'JP14' => 'Kanagawa',
					'JP15' => 'Niigata',
					'JP16' => 'Toyama',
					'JP17' => 'Ishikawa',
					'JP18' => 'Fukui',
					'JP19' => 'Yamanashi',
					'JP20' => 'Nagano',
					'JP21' => 'Gifu',
					'JP22' => 'Shizuoka',
					'JP23' => 'Aichi',
					'JP24' => 'Mie',
					'JP25' => 'Shiga',
					'JP26' => 'Kyoto',
					'JP27' => 'Osaka',
					'JP28' => 'Hyogo',
					'JP29' => 'Nara',
					'JP30' => 'Wakayama',
					'JP31' => 'Tottori',
					'JP32' => 'Shimane',
					'JP33' => 'Okayama',
					'JP34' => 'Hiroshima',
					'JP35' => 'Yamaguchi',
					'JP36' => 'Tokushima',
					'JP37' => 'Kagawa',
					'JP38' => 'Ehime',
					'JP39' => 'Kochi',
					'JP40' => 'Fukuoka',
					'JP41' => 'Saga',
					'JP42' => 'Nagasaki',
					'JP43' => 'Kumamoto',
					'JP44' => 'Oita',
					'JP45' => 'Miyazaki',
					'JP46' => 'Kagoshima',
					'JP47' => 'Okinawa',
				),
		),
	'JE' =>
		array (
			'info' =>
				array (
					'name' => 'Jersey',
					'phone_code' => '+441534',
				),
			'currency' =>
				array (
					'code' => 'JEP',
					'symbol' => '£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'JO' =>
		array (
			'info' =>
				array (
					'name' => 'Jordan',
					'phone_code' => '+962',
				),
			'currency' =>
				array (
					'code' => 'JOD',
					'symbol' => '‎د.أ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KZ' =>
		array (
			'info' =>
				array (
					'name' => 'Kazakhstan',
					'phone_code' => '+7',
				),
			'currency' =>
				array (
					'code' => 'KZT',
					'symbol' => '₸',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KE' =>
		array (
			'info' =>
				array (
					'name' => 'Kenya',
					'phone_code' => '+254',
				),
			'currency' =>
				array (
					'code' => 'KES',
					'symbol' => 'Ksh',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KI' =>
		array (
			'info' =>
				array (
					'name' => 'Kiribati',
					'phone_code' => '+686',
				),
			'currency' =>
				array (
					'code' => 'KID',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KW' =>
		array (
			'info' =>
				array (
					'name' => 'Kuwait',
					'phone_code' => '+965',
				),
			'currency' =>
				array (
					'code' => 'KWD',
					'symbol' => 'د.ك',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KG' =>
		array (
			'info' =>
				array (
					'name' => 'Kyrgyzstan',
					'phone_code' => '+996',
				),
			'currency' =>
				array (
					'code' => 'KGS',
					'symbol' => 'Лв',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LA' =>
		array (
			'info' =>
				array (
					'name' => 'Laos',
					'phone_code' => '+856',
				),
			'currency' =>
				array (
					'code' => 'LAK',
					'symbol' => '₭N',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LV' =>
		array (
			'info' =>
				array (
					'name' => 'Latvia',
					'phone_code' => '+371',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LB' =>
		array (
			'info' =>
				array (
					'name' => 'Lebanon',
					'phone_code' => '+961',
				),
			'currency' =>
				array (
					'code' => 'LBP',
					'symbol' => 'ل.ل.',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LS' =>
		array (
			'info' =>
				array (
					'name' => 'Lesotho',
					'phone_code' => '+266',
				),
			'currency' =>
				array (
					'code' => 'LSL',
					'symbol' => 'L',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LR' =>
		array (
			'info' =>
				array (
					'name' => 'Liberia',
					'phone_code' => '+231',
				),
			'currency' =>
				array (
					'code' => 'LRD',
					'symbol' => '‎L$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'BM' => 'Bomi',
					'BN' => 'Bong',
					'GA' => 'Gbarpolu',
					'GB' => 'Grand Bassa',
					'GC' => 'Grand Cape Mount',
					'GG' => 'Grand Gedeh',
					'GK' => 'Grand Kru',
					'LO' => 'Lofa',
					'MA' => 'Margibi',
					'MY' => 'Maryland',
					'MO' => 'Montserrado',
					'NM' => 'Nimba',
					'RV' => 'Rivercess',
					'RG' => 'River Gee',
					'SN' => 'Sinoe',
				),
		),
	'LY' =>
		array (
			'info' =>
				array (
					'name' => 'Libya',
					'phone_code' => '+218',
				),
			'currency' =>
				array (
					'code' => 'LYD',
					'symbol' => 'ل.د',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LI' =>
		array (
			'info' =>
				array (
					'name' => 'Liechtenstein',
					'phone_code' => '+423',
				),
			'currency' =>
				array (
					'code' => 'CHF',
					'symbol' => 'CHf',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LT' =>
		array (
			'info' =>
				array (
					'name' => 'Lithuania',
					'phone_code' => '+370',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LU' =>
		array (
			'info' =>
				array (
					'name' => 'Luxembourg',
					'phone_code' => '+352',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MK' =>
		array (
			'info' =>
				array (
					'name' => 'North Macedonia',
					'phone_code' => '+389',
				),
			'currency' =>
				array (
					'code' => 'MKD',
					'symbol' => 'Ден',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MG' =>
		array (
			'info' =>
				array (
					'name' => 'Madagascar',
					'phone_code' => '+261',
				),
			'currency' =>
				array (
					'code' => 'MGA',
					'symbol' => 'Ar',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MW' =>
		array (
			'info' =>
				array (
					'name' => 'Malawi',
					'phone_code' => '+265',
				),
			'currency' =>
				array (
					'code' => 'MWK',
					'symbol' => 'MK',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MY' =>
		array (
			'info' =>
				array (
					'name' => 'Malaysia',
					'phone_code' => '+60',
				),
			'currency' =>
				array (
					'code' => 'MYR',
					'symbol' => 'RM',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'JHR' => 'Johor',
					'KDH' => 'Kedah',
					'KTN' => 'Kelantan',
					'LBN' => 'Labuan',
					'MLK' => 'Malacca (Melaka)',
					'NSN' => 'Negeri Sembilan',
					'PHG' => 'Pahang',
					'PNG' => 'Penang (Pulau Pinang)',
					'PRK' => 'Perak',
					'PLS' => 'Perlis',
					'SBH' => 'Sabah',
					'SWK' => 'Sarawak',
					'SGR' => 'Selangor',
					'TRG' => 'Terengganu',
					'PJY' => 'Putrajaya',
					'KUL' => 'Kuala Lumpur',
				),
		),
	'MV' =>
		array (
			'info' =>
				array (
					'name' => 'Maldives',
					'phone_code' => '+960',
				),
			'currency' =>
				array (
					'code' => 'MVR',
					'symbol' => 'Rf',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ML' =>
		array (
			'info' =>
				array (
					'name' => 'Mali',
					'phone_code' => '+223',
				),
			'currency' =>
				array (
					'code' => 'XOF',
					'symbol' => 'CFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MT' =>
		array (
			'info' =>
				array (
					'name' => 'Malta',
					'phone_code' => '+356',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MH' =>
		array (
			'info' =>
				array (
					'name' => 'Marshall Islands',
					'phone_code' => '+692',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MQ' =>
		array (
			'info' =>
				array (
					'name' => 'Martinique',
					'phone_code' => '+596',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MR' =>
		array (
			'info' =>
				array (
					'name' => 'Mauritania',
					'phone_code' => '+222',
				),
			'currency' =>
				array (
					'code' => 'MRU',
					'symbol' => 'UM',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MU' =>
		array (
			'info' =>
				array (
					'name' => 'Mauritius',
					'phone_code' => '+230',
				),
			'currency' =>
				array (
					'code' => 'MUR',
					'symbol' => '₨',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'YT' =>
		array (
			'info' =>
				array (
					'name' => 'Mayotte',
					'phone_code' => '+262',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MX' =>
		array (
			'info' =>
				array (
					'name' => 'Mexico',
					'phone_code' => '+52',
				),
			'currency' =>
				array (
					'code' => 'MXN',
					'symbol' => 'Mex$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'DF' => 'Ciudad de M&eacute;xico',
					'JA' => 'Jalisco',
					'NL' => 'Nuevo Le&oacute;n',
					'AG' => 'Aguascalientes',
					'BC' => 'Baja California',
					'BS' => 'Baja California Sur',
					'CM' => 'Campeche',
					'CS' => 'Chiapas',
					'CH' => 'Chihuahua',
					'CO' => 'Coahuila',
					'CL' => 'Colima',
					'DG' => 'Durango',
					'GT' => 'Guanajuato',
					'GR' => 'Guerrero',
					'HG' => 'Hidalgo',
					'MX' => 'Estado de M&eacute;xico',
					'MI' => 'Michoac&aacute;n',
					'MO' => 'Morelos',
					'NA' => 'Nayarit',
					'OA' => 'Oaxaca',
					'PU' => 'Puebla',
					'QT' => 'Quer&eacute;taro',
					'QR' => 'Quintana Roo',
					'SL' => 'San Luis Potos&iacute;',
					'SI' => 'Sinaloa',
					'SO' => 'Sonora',
					'TB' => 'Tabasco',
					'TM' => 'Tamaulipas',
					'TL' => 'Tlaxcala',
					'VE' => 'Veracruz',
					'YU' => 'Yucat&aacute;n',
					'ZA' => 'Zacatecas',
				),
		),
	'FM' =>
		array (
			'info' =>
				array (
					'name' => 'Micronesia',
					'phone_code' => '+691',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MD' =>
		array (
			'info' =>
				array (
					'name' => 'Moldova',
					'phone_code' => '+373',
				),
			'currency' =>
				array (
					'code' => 'MDL',
					'symbol' => 'L',
					'currency_pos' => 'right_space',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'MD',
											'state' => '',
											'rate' => '20.0000',
											'name' => 'TVA',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'C' => 'Chi&#537;in&#259;u',
					'BL' => 'B&#259;l&#539;i',
					'AN' => 'Anenii Noi',
					'BS' => 'Basarabeasca',
					'BR' => 'Briceni',
					'CH' => 'Cahul',
					'CT' => 'Cantemir',
					'CL' => 'C&#259;l&#259;ra&#537;i',
					'CS' => 'C&#259;u&#537;eni',
					'CM' => 'Cimi&#537;lia',
					'CR' => 'Criuleni',
					'DN' => 'Dondu&#537;eni',
					'DR' => 'Drochia',
					'DB' => 'Dub&#259;sari',
					'ED' => 'Edine&#539;',
					'FL' => 'F&#259;le&#537;ti',
					'FR' => 'Flore&#537;ti',
					'GE' => 'UTA G&#259;g&#259;uzia',
					'GL' => 'Glodeni',
					'HN' => 'H&icirc;nce&#537;ti',
					'IL' => 'Ialoveni',
					'LV' => 'Leova',
					'NS' => 'Nisporeni',
					'OC' => 'Ocni&#539;a',
					'OR' => 'Orhei',
					'RZ' => 'Rezina',
					'RS' => 'R&icirc;&#537;cani',
					'SG' => 'S&icirc;ngerei',
					'SR' => 'Soroca',
					'ST' => 'Str&#259;&#537;eni',
					'SD' => '&#536;old&#259;ne&#537;ti',
					'SV' => '&#536;tefan Vod&#259;',
					'TR' => 'Taraclia',
					'TL' => 'Telene&#537;ti',
					'UN' => 'Ungheni',
				),
		),
	'MC' =>
		array (
			'info' =>
				array (
					'name' => 'Monaco',
					'phone_code' => '+377',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MN' =>
		array (
			'info' =>
				array (
					'name' => 'Mongolia',
					'phone_code' => '+976',
				),
			'currency' =>
				array (
					'code' => 'MNT',
					'symbol' => '₮',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ME' =>
		array (
			'info' =>
				array (
					'name' => 'Montenegro',
					'phone_code' => '+382',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MS' =>
		array (
			'info' =>
				array (
					'name' => 'Montserrat',
					'phone_code' => '+1664',
				),
			'currency' =>
				array (
					'code' => 'XCD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MA' =>
		array (
			'info' =>
				array (
					'name' => 'Morocco',
					'phone_code' => '+212',
				),
			'currency' =>
				array (
					'code' => 'MAD',
					'symbol' => 'DH',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MZ' =>
		array (
			'info' =>
				array (
					'name' => 'Mozambique',
					'phone_code' => '+258',
				),
			'currency' =>
				array (
					'code' => 'MZN',
					'symbol' => 'MTn',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MM' =>
		array (
			'info' =>
				array (
					'name' => 'Myanmar',
					'phone_code' => '+95',
				),
			'currency' =>
				array (
					'code' => 'MMK',
					'symbol' => 'K',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NA' =>
		array (
			'info' =>
				array (
					'name' => 'Namibia',
					'phone_code' => '+264',
				),
			'currency' =>
				array (
					'code' => 'NAD',
					'symbol' => 'N$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NR' =>
		array (
			'info' =>
				array (
					'name' => 'Nauru',
					'phone_code' => '+674',
				),
			'currency' =>
				array (
					'code' => 'AUD',
					'symbol' => 'A$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NP' =>
		array (
			'info' =>
				array (
					'name' => 'Nepal',
					'phone_code' => '+977',
				),
			'currency' =>
				array (
					'code' => 'NPR',
					'symbol' => 'NP₹',
					'currency_pos' => 'left_space',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'NP',
											'state' => '',
											'rate' => '13.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'BAG' => 'Bagmati',
					'BHE' => 'Bheri',
					'DHA' => 'Dhaulagiri',
					'GAN' => 'Gandaki',
					'JAN' => 'Janakpur',
					'KAR' => 'Karnali',
					'KOS' => 'Koshi',
					'LUM' => 'Lumbini',
					'MAH' => 'Mahakali',
					'MEC' => 'Mechi',
					'NAR' => 'Narayani',
					'RAP' => 'Rapti',
					'SAG' => 'Sagarmatha',
					'SET' => 'Seti',
				),
		),
	'NL' =>
		array (
			'info' =>
				array (
					'name' => 'Netherlands',
					'phone_code' => '+31',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'NL',
											'state' => '',
											'rate' => '21.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'NC' =>
		array (
			'info' =>
				array (
					'name' => 'New Caledonia',
					'phone_code' => '+687',
				),
			'currency' =>
				array (
					'code' => 'XPF',
					'symbol' => '₣',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NZ' =>
		array (
			'info' =>
				array (
					'name' => 'New Zealand',
					'phone_code' => '+64',
				),
			'currency' =>
				array (
					'code' => 'NZD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'NL' => 'Northland',
					'AK' => 'Auckland',
					'WA' => 'Waikato',
					'BP' => 'Bay of Plenty',
					'TK' => 'Taranaki',
					'GI' => 'Gisborne',
					'HB' => 'Hawke&rsquo;s Bay',
					'MW' => 'Manawatu-Wanganui',
					'WE' => 'Wellington',
					'NS' => 'Nelson',
					'MB' => 'Marlborough',
					'TM' => 'Tasman',
					'WC' => 'West Coast',
					'CT' => 'Canterbury',
					'OT' => 'Otago',
					'SL' => 'Southland',
				),
		),
	'NI' =>
		array (
			'info' =>
				array (
					'name' => 'Nicaragua',
					'phone_code' => '+505',
				),
			'currency' =>
				array (
					'code' => 'NIO',
					'symbol' => 'C$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NE' =>
		array (
			'info' =>
				array (
					'name' => 'Niger',
					'phone_code' => '+227',
				),
			'currency' =>
				array (
					'code' => 'XOF',
					'symbol' => 'CFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NG' =>
		array (
			'info' =>
				array (
					'name' => 'Nigeria',
					'phone_code' => '+234',
				),
			'currency' =>
				array (
					'code' => 'NGN',
					'symbol' => '₦',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'AB' => 'Abia',
					'FC' => 'Abuja',
					'AD' => 'Adamawa',
					'AK' => 'Akwa Ibom',
					'AN' => 'Anambra',
					'BA' => 'Bauchi',
					'BY' => 'Bayelsa',
					'BE' => 'Benue',
					'BO' => 'Borno',
					'CR' => 'Cross River',
					'DE' => 'Delta',
					'EB' => 'Ebonyi',
					'ED' => 'Edo',
					'EK' => 'Ekiti',
					'EN' => 'Enugu',
					'GO' => 'Gombe',
					'IM' => 'Imo',
					'JI' => 'Jigawa',
					'KD' => 'Kaduna',
					'KN' => 'Kano',
					'KT' => 'Katsina',
					'KE' => 'Kebbi',
					'KO' => 'Kogi',
					'KW' => 'Kwara',
					'LA' => 'Lagos',
					'NA' => 'Nasarawa',
					'NI' => 'Niger',
					'OG' => 'Ogun',
					'ON' => 'Ondo',
					'OS' => 'Osun',
					'OY' => 'Oyo',
					'PL' => 'Plateau',
					'RI' => 'Rivers',
					'SO' => 'Sokoto',
					'TA' => 'Taraba',
					'YO' => 'Yobe',
					'ZA' => 'Zamfara',
				),
		),
	'NU' =>
		array (
			'info' =>
				array (
					'name' => 'Niue',
					'phone_code' => '+683',
				),
			'currency' =>
				array (
					'code' => 'NZD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NF' =>
		array (
			'info' =>
				array (
					'name' => 'Norfolk Island',
					'phone_code' => '+672',
				),
			'currency' =>
				array (
					'code' => 'AUD',
					'symbol' => 'A$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MP' =>
		array (
			'info' =>
				array (
					'name' => 'Northern Mariana Islands',
					'phone_code' => '+1670',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KP' =>
		array (
			'info' =>
				array (
					'name' => 'North Korea',
					'phone_code' => '+850',
				),
			'currency' =>
				array (
					'code' => 'KPW',
					'symbol' => '₩',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'NO' =>
		array (
			'info' =>
				array (
					'name' => 'Norway',
					'phone_code' => '+47',
				),
			'currency' =>
				array (
					'code' => 'NOK',
					'symbol' => 'Kr',
					'currency_pos' => 'left_space',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'NO',
											'state' => '',
											'rate' => '25.0000',
											'name' => 'MVA',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'OM' =>
		array (
			'info' =>
				array (
					'name' => 'Oman',
					'phone_code' => '+968',
				),
			'currency' =>
				array (
					'code' => 'OMR',
					'symbol' => 'ر.ع.',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PK' =>
		array (
			'info' =>
				array (
					'name' => 'Pakistan',
					'phone_code' => '+92',
				),
			'currency' =>
				array (
					'code' => 'PKR',
					'symbol' => '₨',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'JK' => 'Azad Kashmir',
					'BA' => 'Balochistan',
					'TA' => 'FATA',
					'GB' => 'Gilgit Baltistan',
					'IS' => 'Islamabad Capital Territory',
					'KP' => 'Khyber Pakhtunkhwa',
					'PB' => 'Punjab',
					'SD' => 'Sindh',
				),
		),
	'PS' =>
		array (
			'info' =>
				array (
					'name' => 'Palestinian Territory',
					'phone_code' => '+970',
				),
			'currency' =>
				array (
					'code' => 'ILS',
					'symbol' => '₪',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PA' =>
		array (
			'info' =>
				array (
					'name' => 'Panama',
					'phone_code' => '+507',
				),
			'currency' =>
				array (
					'code' => 'PAB',
					'symbol' => 'B/.',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PG' =>
		array (
			'info' =>
				array (
					'name' => 'Papua New Guinea',
					'phone_code' => '+675',
				),
			'currency' =>
				array (
					'code' => 'PGK',
					'symbol' => 'K',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PY' =>
		array (
			'info' =>
				array (
					'name' => 'Paraguay',
					'phone_code' => '+595',
				),
			'currency' =>
				array (
					'code' => 'PYG',
					'symbol' => '₲',
					'currency_pos' => 'left',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'PY',
											'state' => '',
											'rate' => '10.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'PY-ASU' => 'Asunci&oacute;n',
					'PY-1' => 'Concepci&oacute;n',
					'PY-2' => 'San Pedro',
					'PY-3' => 'Cordillera',
					'PY-4' => 'Guair&aacute;',
					'PY-5' => 'Caaguaz&uacute;',
					'PY-6' => 'Caazap&aacute;',
					'PY-7' => 'Itap&uacute;a',
					'PY-8' => 'Misiones',
					'PY-9' => 'Paraguar&iacute;',
					'PY-10' => 'Alto Paran&aacute;',
					'PY-11' => 'Central',
					'PY-12' => '&Ntilde;eembuc&uacute;',
					'PY-13' => 'Amambay',
					'PY-14' => 'Canindey&uacute;',
					'PY-15' => 'Presidente Hayes',
					'PY-16' => 'Alto Paraguay',
					'PY-17' => 'Boquer&oacute;n',
				),
		),
	'PE' =>
		array (
			'info' =>
				array (
					'name' => 'Peru',
					'phone_code' => '+51',
				),
			'currency' =>
				array (
					'code' => 'PEN',
					'symbol' => 'S/',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'CAL' => 'El Callao',
					'LMA' => 'Municipalidad Metropolitana de Lima',
					'AMA' => 'Amazonas',
					'ANC' => 'Ancash',
					'APU' => 'Apur&iacute;mac',
					'ARE' => 'Arequipa',
					'AYA' => 'Ayacucho',
					'CAJ' => 'Cajamarca',
					'CUS' => 'Cusco',
					'HUV' => 'Huancavelica',
					'HUC' => 'Hu&aacute;nuco',
					'ICA' => 'Ica',
					'JUN' => 'Jun&iacute;n',
					'LAL' => 'La Libertad',
					'LAM' => 'Lambayeque',
					'LIM' => 'Lima',
					'LOR' => 'Loreto',
					'MDD' => 'Madre de Dios',
					'MOQ' => 'Moquegua',
					'PAS' => 'Pasco',
					'PIU' => 'Piura',
					'PUN' => 'Puno',
					'SAM' => 'San Mart&iacute;n',
					'TAC' => 'Tacna',
					'TUM' => 'Tumbes',
					'UCA' => 'Ucayali',
				),
		),
	'PH' =>
		array (
			'info' =>
				array (
					'name' => 'Philippines',
					'phone_code' => '+63',
				),
			'currency' =>
				array (
					'code' => 'PHP',
					'symbol' => '₱',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'ABR' => 'Abra',
					'AGN' => 'Agusan del Norte',
					'AGS' => 'Agusan del Sur',
					'AKL' => 'Aklan',
					'ALB' => 'Albay',
					'ANT' => 'Antique',
					'APA' => 'Apayao',
					'AUR' => 'Aurora',
					'BAS' => 'Basilan',
					'BAN' => 'Bataan',
					'BTN' => 'Batanes',
					'BTG' => 'Batangas',
					'BEN' => 'Benguet',
					'BIL' => 'Biliran',
					'BOH' => 'Bohol',
					'BUK' => 'Bukidnon',
					'BUL' => 'Bulacan',
					'CAG' => 'Cagayan',
					'CAN' => 'Camarines Norte',
					'CAS' => 'Camarines Sur',
					'CAM' => 'Camiguin',
					'CAP' => 'Capiz',
					'CAT' => 'Catanduanes',
					'CAV' => 'Cavite',
					'CEB' => 'Cebu',
					'COM' => 'Compostela Valley',
					'NCO' => 'Cotabato',
					'DAV' => 'Davao del Norte',
					'DAS' => 'Davao del Sur',
					'DAC' => 'Davao Occidental',
					'DAO' => 'Davao Oriental',
					'DIN' => 'Dinagat Islands',
					'EAS' => 'Eastern Samar',
					'GUI' => 'Guimaras',
					'IFU' => 'Ifugao',
					'ILN' => 'Ilocos Norte',
					'ILS' => 'Ilocos Sur',
					'ILI' => 'Iloilo',
					'ISA' => 'Isabela',
					'KAL' => 'Kalinga',
					'LUN' => 'La Union',
					'LAG' => 'Laguna',
					'LAN' => 'Lanao del Norte',
					'LAS' => 'Lanao del Sur',
					'LEY' => 'Leyte',
					'MAG' => 'Maguindanao',
					'MAD' => 'Marinduque',
					'MAS' => 'Masbate',
					'MSC' => 'Misamis Occidental',
					'MSR' => 'Misamis Oriental',
					'MOU' => 'Mountain Province',
					'NEC' => 'Negros Occidental',
					'NER' => 'Negros Oriental',
					'NSA' => 'Northern Samar',
					'NUE' => 'Nueva Ecija',
					'NUV' => 'Nueva Vizcaya',
					'MDC' => 'Occidental Mindoro',
					'MDR' => 'Oriental Mindoro',
					'PLW' => 'Palawan',
					'PAM' => 'Pampanga',
					'PAN' => 'Pangasinan',
					'QUE' => 'Quezon',
					'QUI' => 'Quirino',
					'RIZ' => 'Rizal',
					'ROM' => 'Romblon',
					'WSA' => 'Samar',
					'SAR' => 'Sarangani',
					'SIQ' => 'Siquijor',
					'SOR' => 'Sorsogon',
					'SCO' => 'South Cotabato',
					'SLE' => 'Southern Leyte',
					'SUK' => 'Sultan Kudarat',
					'SLU' => 'Sulu',
					'SUN' => 'Surigao del Norte',
					'SUR' => 'Surigao del Sur',
					'TAR' => 'Tarlac',
					'TAW' => 'Tawi-Tawi',
					'ZMB' => 'Zambales',
					'ZAN' => 'Zamboanga del Norte',
					'ZAS' => 'Zamboanga del Sur',
					'ZSI' => 'Zamboanga Sibugay',
					'00' => 'Metro Manila',
				),
		),
	'PN' =>
		array (
			'info' =>
				array (
					'name' => 'Pitcairn',
					'phone_code' => '+870',
				),
			'currency' =>
				array (
					'code' => 'PND',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PL' =>
		array (
			'info' =>
				array (
					'name' => 'Poland',
					'phone_code' => '+48',
				),
			'currency' =>
				array (
					'code' => 'PLN',
					'symbol' => 'zł',
					'currency_pos' => 'right_space',
					'thousand' => ' ',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'PL',
											'state' => '',
											'rate' => '23.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'PT' =>
		array (
			'info' =>
				array (
					'name' => 'Portugal',
					'phone_code' => '+351',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PR' =>
		array (
			'info' =>
				array (
					'name' => 'Puerto Rico',
					'phone_code' =>
						array (
							0 => '+1787',
							1 => '+1939',
						),
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'QA' =>
		array (
			'info' =>
				array (
					'name' => 'Qatar',
					'phone_code' => '+974',
				),
			'currency' =>
				array (
					'code' => 'QAR',
					'symbol' => 'ر.ق',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'RE' =>
		array (
			'info' =>
				array (
					'name' => 'Reunion',
					'phone_code' => '+262',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'RO' =>
		array (
			'info' =>
				array (
					'name' => 'Romania',
					'phone_code' => '+40',
				),
			'currency' =>
				array (
					'code' => 'RON',
					'symbol' => 'ROL',
					'currency_pos' => 'right_space',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'RO',
											'state' => '',
											'rate' => '19.0000',
											'name' => 'TVA',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'AB' => 'Alba',
					'AR' => 'Arad',
					'AG' => 'Arge&#537;',
					'BC' => 'Bac&#259;u',
					'BH' => 'Bihor',
					'BN' => 'Bistri&#539;a-N&#259;s&#259;ud',
					'BT' => 'Boto&#537;ani',
					'BR' => 'Br&#259;ila',
					'BV' => 'Bra&#537;ov',
					'B' => 'Bucure&#537;ti',
					'BZ' => 'Buz&#259;u',
					'CL' => 'C&#259;l&#259;ra&#537;i',
					'CS' => 'Cara&#537;-Severin',
					'CJ' => 'Cluj',
					'CT' => 'Constan&#539;a',
					'CV' => 'Covasna',
					'DB' => 'D&acirc;mbovi&#539;a',
					'DJ' => 'Dolj',
					'GL' => 'Gala&#539;i',
					'GR' => 'Giurgiu',
					'GJ' => 'Gorj',
					'HR' => 'Harghita',
					'HD' => 'Hunedoara',
					'IL' => 'Ialomi&#539;a',
					'IS' => 'Ia&#537;i',
					'IF' => 'Ilfov',
					'MM' => 'Maramure&#537;',
					'MH' => 'Mehedin&#539;i',
					'MS' => 'Mure&#537;',
					'NT' => 'Neam&#539;',
					'OT' => 'Olt',
					'PH' => 'Prahova',
					'SJ' => 'S&#259;laj',
					'SM' => 'Satu Mare',
					'SB' => 'Sibiu',
					'SV' => 'Suceava',
					'TR' => 'Teleorman',
					'TM' => 'Timi&#537;',
					'TL' => 'Tulcea',
					'VL' => 'V&acirc;lcea',
					'VS' => 'Vaslui',
					'VN' => 'Vrancea',
				),
		),
	'RU' =>
		array (
			'info' =>
				array (
					'name' => 'Russia',
					'phone_code' => '+7',
				),
			'currency' =>
				array (
					'code' => 'RUB',
					'symbol' => '₽',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'RW' =>
		array (
			'info' =>
				array (
					'name' => 'Rwanda',
					'phone_code' => '+250',
				),
			'currency' =>
				array (
					'code' => 'RWF',
					'symbol' => 'R₣',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'BL' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Barth&eacute;lemy',
					'phone_code' => '+590',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SH' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Helena',
					'phone_code' => '+290',
				),
			'currency' =>
				array (
					'code' => 'SHP',
					'symbol' => '£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KN' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Kitts and Nevis',
					'phone_code' => '+1869',
				),
			'currency' =>
				array (
					'code' => 'XCD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'LC' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Lucia',
					'phone_code' => '+1758',
				),
			'currency' =>
				array (
					'code' => 'XCD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'MF' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Martin (French part)',
					'phone_code' => '+590',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SX' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Martin (Dutch part)',
					'phone_code' => '+599',
				),
			'currency' =>
				array (
					'code' => 'ANG',
					'symbol' => 'ƒ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'PM' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Pierre and Miquelon',
					'phone_code' => '+508',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'VC' =>
		array (
			'info' =>
				array (
					'name' => 'Saint Vincent and the Grenadines',
					'phone_code' => '+1784',
				),
			'currency' =>
				array (
					'code' => 'XCD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SM' =>
		array (
			'info' =>
				array (
					'name' => 'San Marino',
					'phone_code' => '+378',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ST' =>
		array (
			'info' =>
				array (
					'name' => 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe',
					'phone_code' => '+239',
				),
			'currency' =>
				array (
					'code' => 'STN',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SA' =>
		array (
			'info' =>
				array (
					'name' => 'Saudi Arabia',
					'phone_code' => '+966',
				),
			'currency' =>
				array (
					'code' => 'SAR',
					'symbol' => 'ر.س',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SN' =>
		array (
			'info' =>
				array (
					'name' => 'Senegal',
					'phone_code' => '+221',
				),
			'currency' =>
				array (
					'code' => 'XOF',
					'symbol' => 'CFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'RS' =>
		array (
			'info' =>
				array (
					'name' => 'Serbia',
					'phone_code' => '+381',
				),
			'currency' =>
				array (
					'code' => 'RSD',
					'symbol' => 'дин',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SC' =>
		array (
			'info' =>
				array (
					'name' => 'Seychelles',
					'phone_code' => '+248',
				),
			'currency' =>
				array (
					'code' => 'SCR',
					'symbol' => 'SRe',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SL' =>
		array (
			'info' =>
				array (
					'name' => 'Sierra Leone',
					'phone_code' => '+232',
				),
			'currency' =>
				array (
					'code' => 'SLL',
					'symbol' => 'Le',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SG' =>
		array (
			'info' =>
				array (
					'name' => 'Singapore',
					'phone_code' => '+65',
				),
			'currency' =>
				array (
					'code' => 'SGD',
					'symbol' => 'S$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SK' =>
		array (
			'info' =>
				array (
					'name' => 'Slovakia',
					'phone_code' => '+421',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SI' =>
		array (
			'info' =>
				array (
					'name' => 'Slovenia',
					'phone_code' => '+386',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SB' =>
		array (
			'info' =>
				array (
					'name' => 'Solomon Islands',
					'phone_code' => '+677',
				),
			'currency' =>
				array (
					'code' => 'SBD',
					'symbol' => 'Si$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SO' =>
		array (
			'info' =>
				array (
					'name' => 'Somalia',
					'phone_code' => '+252',
				),
			'currency' =>
				array (
					'code' => 'SOS',
					'symbol' => 'Sh.so',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ZA' =>
		array (
			'info' =>
				array (
					'name' => 'South Africa',
					'phone_code' => '+27',
				),
			'currency' =>
				array (
					'code' => 'ZAR',
					'symbol' => 'R',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'ZA',
											'state' => '',
											'rate' => '15.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'EC' => 'Eastern Cape',
					'FS' => 'Free State',
					'GP' => 'Gauteng',
					'KZN' => 'KwaZulu-Natal',
					'LP' => 'Limpopo',
					'MP' => 'Mpumalanga',
					'NC' => 'Northern Cape',
					'NW' => 'North West',
					'WC' => 'Western Cape',
				),
		),
	'GS' =>
		array (
			'info' =>
				array (
					'name' => 'South Georgia/Sandwich Islands',
					'phone_code' => '',
				),
			'currency' =>
				array (
					'code' => 'GBP',
					'symbol' => '£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'KR' =>
		array (
			'info' =>
				array (
					'name' => 'South Korea',
					'phone_code' => '+82',
				),
			'currency' =>
				array (
					'code' => 'KRW',
					'symbol' => '₩',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SS' =>
		array (
			'info' =>
				array (
					'name' => 'South Sudan',
					'phone_code' => '+211',
				),
			'currency' =>
				array (
					'code' => 'SSP',
					'symbol' => 'SS£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ES' =>
		array (
			'info' =>
				array (
					'name' => 'Spain',
					'phone_code' => '+34',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'right',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'ES',
											'state' => '',
											'rate' => '21.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'C' => 'A Coru&ntilde;a',
					'VI' => 'Araba/&Aacute;lava',
					'AB' => 'Albacete',
					'A' => 'Alicante',
					'AL' => 'Almer&iacute;a',
					'O' => 'Asturias',
					'AV' => '&Aacute;vila',
					'BA' => 'Badajoz',
					'PM' => 'Baleares',
					'B' => 'Barcelona',
					'BU' => 'Burgos',
					'CC' => 'C&aacute;ceres',
					'CA' => 'C&aacute;diz',
					'S' => 'Cantabria',
					'CS' => 'Castell&oacute;n',
					'CE' => 'Ceuta',
					'CR' => 'Ciudad Real',
					'CO' => 'C&oacute;rdoba',
					'CU' => 'Cuenca',
					'GI' => 'Girona',
					'GR' => 'Granada',
					'GU' => 'Guadalajara',
					'SS' => 'Gipuzkoa',
					'H' => 'Huelva',
					'HU' => 'Huesca',
					'J' => 'Ja&eacute;n',
					'LO' => 'La Rioja',
					'GC' => 'Las Palmas',
					'LE' => 'Le&oacute;n',
					'L' => 'Lleida',
					'LU' => 'Lugo',
					'M' => 'Madrid',
					'MA' => 'M&aacute;laga',
					'ML' => 'Melilla',
					'MU' => 'Murcia',
					'NA' => 'Navarra',
					'OR' => 'Ourense',
					'P' => 'Palencia',
					'PO' => 'Pontevedra',
					'SA' => 'Salamanca',
					'TF' => 'Santa Cruz de Tenerife',
					'SG' => 'Segovia',
					'SE' => 'Sevilla',
					'SO' => 'Soria',
					'T' => 'Tarragona',
					'TE' => 'Teruel',
					'TO' => 'Toledo',
					'V' => 'Valencia',
					'VA' => 'Valladolid',
					'BI' => 'Bizkaia',
					'ZA' => 'Zamora',
					'Z' => 'Zaragoza',
				),
		),
	'LK' =>
		array (
			'info' =>
				array (
					'name' => 'Sri Lanka',
					'phone_code' => '+94',
				),
			'currency' =>
				array (
					'code' => 'LKR',
					'symbol' => 'ரூ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SD' =>
		array (
			'info' =>
				array (
					'name' => 'Sudan',
					'phone_code' => '+249',
				),
			'currency' =>
				array (
					'code' => 'SDG',
					'symbol' => 'ج.س',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SR' =>
		array (
			'info' =>
				array (
					'name' => 'Suriname',
					'phone_code' => '+597',
				),
			'currency' =>
				array (
					'code' => 'SRD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SJ' =>
		array (
			'info' =>
				array (
					'name' => 'Svalbard and Jan Mayen',
					'phone_code' => '+47',
				),
			'currency' =>
				array (
					'code' => 'NOK',
					'symbol' => 'kr',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SZ' =>
		array (
			'info' =>
				array (
					'name' => 'Swaziland',
					'phone_code' => '+268',
				),
			'currency' =>
				array (
					'code' => 'SZL',
					'symbol' => 'E',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'SE' =>
		array (
			'info' =>
				array (
					'name' => 'Sweden',
					'phone_code' => '+46',
				),
			'currency' =>
				array (
					'code' => 'SEK',
					'symbol' => 'kr',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'CH' =>
		array (
			'info' =>
				array (
					'name' => 'Switzerland',
					'phone_code' => '+41',
				),
			'currency' =>
				array (
					'code' => 'CHF',
					'symbol' => 'CHf',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'AG' => 'Aargau',
					'AR' => 'Appenzell Ausserrhoden',
					'AI' => 'Appenzell Innerrhoden',
					'BL' => 'Basel-Landschaft',
					'BS' => 'Basel-Stadt',
					'BE' => 'Bern',
					'FR' => 'Fribourg',
					'GE' => 'Geneva',
					'GL' => 'Glarus',
					'GR' => 'Graub&uuml;nden',
					'JU' => 'Jura',
					'LU' => 'Luzern',
					'NE' => 'Neuch&acirc;tel',
					'NW' => 'Nidwalden',
					'OW' => 'Obwalden',
					'SH' => 'Schaffhausen',
					'SZ' => 'Schwyz',
					'SO' => 'Solothurn',
					'SG' => 'St. Gallen',
					'TG' => 'Thurgau',
					'TI' => 'Ticino',
					'UR' => 'Uri',
					'VS' => 'Valais',
					'VD' => 'Vaud',
					'ZG' => 'Zug',
					'ZH' => 'Z&uuml;rich',
				),
		),
	'SY' =>
		array (
			'info' =>
				array (
					'name' => 'Syria',
					'phone_code' => '+963',
				),
			'currency' =>
				array (
					'code' => 'SYP',
					'symbol' => '£S',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TW' =>
		array (
			'info' =>
				array (
					'name' => 'Taiwan',
					'phone_code' => '+886',
				),
			'currency' =>
				array (
					'code' => 'TWD',
					'symbol' => 'NT$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TJ' =>
		array (
			'info' =>
				array (
					'name' => 'Tajikistan',
					'phone_code' => '+992',
				),
			'currency' =>
				array (
					'code' => 'TJS',
					'symbol' => 'SM',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TZ' =>
		array (
			'info' =>
				array (
					'name' => 'Tanzania',
					'phone_code' => '+255',
				),
			'currency' =>
				array (
					'code' => 'TZS',
					'symbol' => 'TSh',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
					'TZ01' => 'Arusha',
					'TZ02' => 'Dar es Salaam',
					'TZ03' => 'Dodoma',
					'TZ04' => 'Iringa',
					'TZ05' => 'Kagera',
					'TZ06' => 'Pemba North',
					'TZ07' => 'Zanzibar North',
					'TZ08' => 'Kigoma',
					'TZ09' => 'Kilimanjaro',
					'TZ10' => 'Pemba South',
					'TZ11' => 'Zanzibar South',
					'TZ12' => 'Lindi',
					'TZ13' => 'Mara',
					'TZ14' => 'Mbeya',
					'TZ15' => 'Zanzibar West',
					'TZ16' => 'Morogoro',
					'TZ17' => 'Mtwara',
					'TZ18' => 'Mwanza',
					'TZ19' => 'Coast',
					'TZ20' => 'Rukwa',
					'TZ21' => 'Ruvuma',
					'TZ22' => 'Shinyanga',
					'TZ23' => 'Singida',
					'TZ24' => 'Tabora',
					'TZ25' => 'Tanga',
					'TZ26' => 'Manyara',
					'TZ27' => 'Geita',
					'TZ28' => 'Katavi',
					'TZ29' => 'Njombe',
					'TZ30' => 'Simiyu',
				),
		),
	'TH' =>
		array (
			'info' =>
				array (
					'name' => 'Thailand',
					'phone_code' => '+66',
				),
			'currency' =>
				array (
					'code' => 'THB',
					'symbol' => '฿',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'TH',
											'state' => '',
											'rate' => '7.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'TH-37' => 'Amnat Charoen',
					'TH-15' => 'Ang Thong',
					'TH-14' => 'Ayutthaya',
					'TH-10' => 'Bangkok',
					'TH-38' => 'Bueng Kan',
					'TH-31' => 'Buri Ram',
					'TH-24' => 'Chachoengsao',
					'TH-18' => 'Chai Nat',
					'TH-36' => 'Chaiyaphum',
					'TH-22' => 'Chanthaburi',
					'TH-50' => 'Chiang Mai',
					'TH-57' => 'Chiang Rai',
					'TH-20' => 'Chonburi',
					'TH-86' => 'Chumphon',
					'TH-46' => 'Kalasin',
					'TH-62' => 'Kamphaeng Phet',
					'TH-71' => 'Kanchanaburi',
					'TH-40' => 'Khon Kaen',
					'TH-81' => 'Krabi',
					'TH-52' => 'Lampang',
					'TH-51' => 'Lamphun',
					'TH-42' => 'Loei',
					'TH-16' => 'Lopburi',
					'TH-58' => 'Mae Hong Son',
					'TH-44' => 'Maha Sarakham',
					'TH-49' => 'Mukdahan',
					'TH-26' => 'Nakhon Nayok',
					'TH-73' => 'Nakhon Pathom',
					'TH-48' => 'Nakhon Phanom',
					'TH-30' => 'Nakhon Ratchasima',
					'TH-60' => 'Nakhon Sawan',
					'TH-80' => 'Nakhon Si Thammarat',
					'TH-55' => 'Nan',
					'TH-96' => 'Narathiwat',
					'TH-39' => 'Nong Bua Lam Phu',
					'TH-43' => 'Nong Khai',
					'TH-12' => 'Nonthaburi',
					'TH-13' => 'Pathum Thani',
					'TH-94' => 'Pattani',
					'TH-82' => 'Phang Nga',
					'TH-93' => 'Phatthalung',
					'TH-56' => 'Phayao',
					'TH-67' => 'Phetchabun',
					'TH-76' => 'Phetchaburi',
					'TH-66' => 'Phichit',
					'TH-65' => 'Phitsanulok',
					'TH-54' => 'Phrae',
					'TH-83' => 'Phuket',
					'TH-25' => 'Prachin Buri',
					'TH-77' => 'Prachuap Khiri Khan',
					'TH-85' => 'Ranong',
					'TH-70' => 'Ratchaburi',
					'TH-21' => 'Rayong',
					'TH-45' => 'Roi Et',
					'TH-27' => 'Sa Kaeo',
					'TH-47' => 'Sakon Nakhon',
					'TH-11' => 'Samut Prakan',
					'TH-74' => 'Samut Sakhon',
					'TH-75' => 'Samut Songkhram',
					'TH-19' => 'Saraburi',
					'TH-91' => 'Satun',
					'TH-17' => 'Sing Buri',
					'TH-33' => 'Sisaket',
					'TH-90' => 'Songkhla',
					'TH-64' => 'Sukhothai',
					'TH-72' => 'Suphan Buri',
					'TH-84' => 'Surat Thani',
					'TH-32' => 'Surin',
					'TH-63' => 'Tak',
					'TH-92' => 'Trang',
					'TH-23' => 'Trat',
					'TH-34' => 'Ubon Ratchathani',
					'TH-41' => 'Udon Thani',
					'TH-61' => 'Uthai Thani',
					'TH-53' => 'Uttaradit',
					'TH-95' => 'Yala',
					'TH-35' => 'Yasothon',
				),
		),
	'TL' =>
		array (
			'info' =>
				array (
					'name' => 'Timor-Leste',
					'phone_code' => '+670',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TG' =>
		array (
			'info' =>
				array (
					'name' => 'Togo',
					'phone_code' => '+228',
				),
			'currency' =>
				array (
					'code' => 'XOF',
					'symbol' => 'CFA',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TK' =>
		array (
			'info' =>
				array (
					'name' => 'Tokelau',
					'phone_code' => '+690',
				),
			'currency' =>
				array (
					'code' => 'NZD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TO' =>
		array (
			'info' =>
				array (
					'name' => 'Tonga',
					'phone_code' => '+676',
				),
			'currency' =>
				array (
					'code' => 'TOP',
					'symbol' => 'T$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TT' =>
		array (
			'info' =>
				array (
					'name' => 'Trinidad and Tobago',
					'phone_code' => '+1868',
				),
			'currency' =>
				array (
					'code' => 'TTD',
					'symbol' => 'TT$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TN' =>
		array (
			'info' =>
				array (
					'name' => 'Tunisia',
					'phone_code' => '+216',
				),
			'currency' =>
				array (
					'code' => 'TND',
					'symbol' => 'د.ت',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TR' =>
		array (
			'info' =>
				array (
					'name' => 'Turkey',
					'phone_code' => '+90',
				),
			'currency' =>
				array (
					'code' => 'TRY',
					'symbol' => '₺',
					'currency_pos' => 'left_space',
					'thousand' => '.',
					'decimal' => ',',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'TR',
											'state' => '',
											'rate' => '18.0000',
											'name' => 'KDV',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'TR01' => 'Adana',
					'TR02' => 'Ad&#305;yaman',
					'TR03' => 'Afyon',
					'TR04' => 'A&#287;r&#305;',
					'TR05' => 'Amasya',
					'TR06' => 'Ankara',
					'TR07' => 'Antalya',
					'TR08' => 'Artvin',
					'TR09' => 'Ayd&#305;n',
					'TR10' => 'Bal&#305;kesir',
					'TR11' => 'Bilecik',
					'TR12' => 'Bing&#246;l',
					'TR13' => 'Bitlis',
					'TR14' => 'Bolu',
					'TR15' => 'Burdur',
					'TR16' => 'Bursa',
					'TR17' => '&#199;anakkale',
					'TR18' => '&#199;ank&#305;r&#305;',
					'TR19' => '&#199;orum',
					'TR20' => 'Denizli',
					'TR21' => 'Diyarbak&#305;r',
					'TR22' => 'Edirne',
					'TR23' => 'Elaz&#305;&#287;',
					'TR24' => 'Erzincan',
					'TR25' => 'Erzurum',
					'TR26' => 'Eski&#351;ehir',
					'TR27' => 'Gaziantep',
					'TR28' => 'Giresun',
					'TR29' => 'G&#252;m&#252;&#351;hane',
					'TR30' => 'Hakkari',
					'TR31' => 'Hatay',
					'TR32' => 'Isparta',
					'TR33' => '&#304;&#231;el',
					'TR34' => '&#304;stanbul',
					'TR35' => '&#304;zmir',
					'TR36' => 'Kars',
					'TR37' => 'Kastamonu',
					'TR38' => 'Kayseri',
					'TR39' => 'K&#305;rklareli',
					'TR40' => 'K&#305;r&#351;ehir',
					'TR41' => 'Kocaeli',
					'TR42' => 'Konya',
					'TR43' => 'K&#252;tahya',
					'TR44' => 'Malatya',
					'TR45' => 'Manisa',
					'TR46' => 'Kahramanmara&#351;',
					'TR47' => 'Mardin',
					'TR48' => 'Mu&#287;la',
					'TR49' => 'Mu&#351;',
					'TR50' => 'Nev&#351;ehir',
					'TR51' => 'Ni&#287;de',
					'TR52' => 'Ordu',
					'TR53' => 'Rize',
					'TR54' => 'Sakarya',
					'TR55' => 'Samsun',
					'TR56' => 'Siirt',
					'TR57' => 'Sinop',
					'TR58' => 'Sivas',
					'TR59' => 'Tekirda&#287;',
					'TR60' => 'Tokat',
					'TR61' => 'Trabzon',
					'TR62' => 'Tunceli',
					'TR63' => '&#350;anl&#305;urfa',
					'TR64' => 'U&#351;ak',
					'TR65' => 'Van',
					'TR66' => 'Yozgat',
					'TR67' => 'Zonguldak',
					'TR68' => 'Aksaray',
					'TR69' => 'Bayburt',
					'TR70' => 'Karaman',
					'TR71' => 'K&#305;r&#305;kkale',
					'TR72' => 'Batman',
					'TR73' => '&#350;&#305;rnak',
					'TR74' => 'Bart&#305;n',
					'TR75' => 'Ardahan',
					'TR76' => 'I&#287;d&#305;r',
					'TR77' => 'Yalova',
					'TR78' => 'Karab&#252;k',
					'TR79' => 'Kilis',
					'TR80' => 'Osmaniye',
					'TR81' => 'D&#252;zce',
				),
		),
	'TM' =>
		array (
			'info' =>
				array (
					'name' => 'Turkmenistan',
					'phone_code' => '+993',
				),
			'currency' =>
				array (
					'code' => 'TMT',
					'symbol' => 'T',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TC' =>
		array (
			'info' =>
				array (
					'name' => 'Turks and Caicos Islands',
					'phone_code' => '+1649',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'TV' =>
		array (
			'info' =>
				array (
					'name' => 'Tuvalu',
					'phone_code' => '+688',
				),
			'currency' =>
				array (
					'code' => 'TVD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'UG' =>
		array (
			'info' =>
				array (
					'name' => 'Uganda',
					'phone_code' => '+256',
				),
			'currency' =>
				array (
					'code' => 'UGX',
					'symbol' => 'USh',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'UA' =>
		array (
			'info' =>
				array (
					'name' => 'Ukraine',
					'phone_code' => '+380',
				),
			'currency' =>
				array (
					'code' => 'UAH',
					'symbol' => '₴',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'AE' =>
		array (
			'info' =>
				array (
					'name' => 'United Arab Emirates',
					'phone_code' => '+971',
				),
			'currency' =>
				array (
					'code' => 'AED',
					'symbol' => 'د.إ',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'GB' =>
		array (
			'info' =>
				array (
					'name' => 'United Kingdom (UK)',
					'phone_code' => '+44',
				),
			'currency' =>
				array (
					'code' => 'GBP',
					'symbol' => '£',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'kg',
					'dimension_unit' => 'cm',
					'tax_rates' =>
						array (
							'' =>
								array (
									0 =>
										array (
											'country' => 'GB',
											'state' => '',
											'rate' => '20.0000',
											'name' => 'VAT',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
				),
		),
	'US' =>
		array (
			'info' =>
				array (
					'name' => 'United States (US)',
					'phone_code' => '+1',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => 2,
					'weight_unit' => 'oz',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
							'AL' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'AL',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'AZ' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'AZ',
											'rate' => '5.6000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'AR' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'AR',
											'rate' => '6.5000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'CA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'CA',
											'rate' => '7.5000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'CO' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'CO',
											'rate' => '2.9000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'CT' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'CT',
											'rate' => '6.3500',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'DC' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'DC',
											'rate' => '5.7500',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'FL' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'FL',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'GA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'GA',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'GU' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'GU',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'HI' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'HI',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'ID' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'ID',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'IL' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'IL',
											'rate' => '6.2500',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'IN' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'IN',
											'rate' => '7.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'IA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'IA',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'KS' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'KS',
											'rate' => '6.1500',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'KY' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'KY',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'LA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'LA',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'ME' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'ME',
											'rate' => '5.5000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'MD' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'MD',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'MA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'MA',
											'rate' => '6.2500',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'MI' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'MI',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'MN' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'MN',
											'rate' => '6.8750',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'MS' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'MS',
											'rate' => '7.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'MO' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'MO',
											'rate' => '4.225',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'NE' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'NE',
											'rate' => '5.5000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'NV' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'NV',
											'rate' => '6.8500',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'NJ' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'NJ',
											'rate' => '6.8750',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'NM' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'NM',
											'rate' => '5.1250',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'NY' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'NY',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'NC' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'NC',
											'rate' => '4.7500',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'ND' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'ND',
											'rate' => '5.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'OH' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'OH',
											'rate' => '5.7500',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'OK' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'OK',
											'rate' => '4.5000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'PA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'PA',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'PR' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'PR',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'RI' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'RI',
											'rate' => '7.0000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'SC' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'SC',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'SD' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'SD',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'TN' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'TN',
											'rate' => '7.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'TX' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'TX',
											'rate' => '6.2500',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'UT' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'UT',
											'rate' => '5.9500',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'VT' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'VT',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'VA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'VA',
											'rate' => '5.3000',
											'name' => 'State Tax',
											'shipping' => false,
										),
								),
							'WA' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'WA',
											'rate' => '6.5000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'WV' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'WV',
											'rate' => '6.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'WI' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'WI',
											'rate' => '5.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
							'WY' =>
								array (
									0 =>
										array (
											'country' => 'US',
											'state' => 'WY',
											'rate' => '4.0000',
											'name' => 'State Tax',
											'shipping' => true,
										),
								),
						),
				),
			'states' =>
				array (
					'AL' => 'Alabama',
					'AK' => 'Alaska',
					'AZ' => 'Arizona',
					'AR' => 'Arkansas',
					'CA' => 'California',
					'CO' => 'Colorado',
					'CT' => 'Connecticut',
					'DE' => 'Delaware',
					'DC' => 'District Of Columbia',
					'FL' => 'Florida',
					'GA' => 'Georgia',
					'HI' => 'Hawaii',
					'ID' => 'Idaho',
					'IL' => 'Illinois',
					'IN' => 'Indiana',
					'IA' => 'Iowa',
					'KS' => 'Kansas',
					'KY' => 'Kentucky',
					'LA' => 'Louisiana',
					'ME' => 'Maine',
					'MD' => 'Maryland',
					'MA' => 'Massachusetts',
					'MI' => 'Michigan',
					'MN' => 'Minnesota',
					'MS' => 'Mississippi',
					'MO' => 'Missouri',
					'MT' => 'Montana',
					'NE' => 'Nebraska',
					'NV' => 'Nevada',
					'NH' => 'New Hampshire',
					'NJ' => 'New Jersey',
					'NM' => 'New Mexico',
					'NY' => 'New York',
					'NC' => 'North Carolina',
					'ND' => 'North Dakota',
					'OH' => 'Ohio',
					'OK' => 'Oklahoma',
					'OR' => 'Oregon',
					'PA' => 'Pennsylvania',
					'RI' => 'Rhode Island',
					'SC' => 'South Carolina',
					'SD' => 'South Dakota',
					'TN' => 'Tennessee',
					'TX' => 'Texas',
					'UT' => 'Utah',
					'VT' => 'Vermont',
					'VA' => 'Virginia',
					'WA' => 'Washington',
					'WV' => 'West Virginia',
					'WI' => 'Wisconsin',
					'WY' => 'Wyoming',
					'AA' => 'Armed Forces (AA)',
					'AE' => 'Armed Forces (AE)',
					'AP' => 'Armed Forces (AP)',
				),
		),
	'UM' =>
		array (
			'info' =>
				array (
					'name' => 'United States (US) Minor Outlying Islands',
					'phone_code' => '+1',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'UY' =>
		array (
			'info' =>
				array (
					'name' => 'Uruguay',
					'phone_code' => '+598',
				),
			'currency' =>
				array (
					'code' => 'UYU',
					'symbol' => '$U',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'UZ' =>
		array (
			'info' =>
				array (
					'name' => 'Uzbekistan',
					'phone_code' => '+998',
				),
			'currency' =>
				array (
					'code' => 'UZS',
					'symbol' => 'лв',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'VU' =>
		array (
			'info' =>
				array (
					'name' => 'Vanuatu',
					'phone_code' => '+678',
				),
			'currency' =>
				array (
					'code' => 'VUV',
					'symbol' => 'VT',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'VA' =>
		array (
			'info' =>
				array (
					'name' => 'Vatican',
					'phone_code' => '+379',
				),
			'currency' =>
				array (
					'code' => 'EUR',
					'symbol' => '€',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'VE' =>
		array (
			'info' =>
				array (
					'name' => 'Venezuela',
					'phone_code' => '+58',
				),
			'currency' =>
				array (
					'code' => 'VES',
					'symbol' => 'Bs.',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'VN' =>
		array (
			'info' =>
				array (
					'name' => 'Vietnam',
					'phone_code' => '+84',
				),
			'currency' =>
				array (
					'code' => 'VND',
					'symbol' => '₫',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'VG' =>
		array (
			'info' =>
				array (
					'name' => 'Virgin Islands (British)',
					'phone_code' => '+1284',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'VI' =>
		array (
			'info' =>
				array (
					'name' => 'Virgin Islands (US)',
					'phone_code' => '+1340',
				),
			'currency' =>
				array (
					'code' => 'USD',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'WF' =>
		array (
			'info' =>
				array (
					'name' => 'Wallis and Futuna',
					'phone_code' => '+681',
				),
			'currency' =>
				array (
					'code' => 'XPF',
					'symbol' => '₣',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'EH' =>
		array (
			'info' =>
				array (
					'name' => 'Western Sahara',
					'phone_code' => '+212',
				),
			'currency' =>
				array (
					'code' => 'MAD',
					'symbol' => 'د.م',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'WS' =>
		array (
			'info' =>
				array (
					'name' => 'Samoa',
					'phone_code' => '+685',
				),
			'currency' =>
				array (
					'code' => 'WST',
					'symbol' => 'WS$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'YE' =>
		array (
			'info' =>
				array (
					'name' => 'Yemen',
					'phone_code' => '+967',
				),
			'currency' =>
				array (
					'code' => 'YER',
					'symbol' => '﷼',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ZM' =>
		array (
			'info' =>
				array (
					'name' => 'Zambia',
					'phone_code' => '+260',
				),
			'currency' =>
				array (
					'code' => 'ZMW',
					'symbol' => 'ZK',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),
	'ZW' =>
		array (
			'info' =>
				array (
					'name' => 'Zimbabwe',
					'phone_code' => '+263',
				),
			'currency' =>
				array (
					'code' => 'ZWL',
					'symbol' => '$',
					'currency_pos' => 'left',
					'thousand' => ',',
					'decimal' => '.',
					'num_decimals' => '2',
					'weight_unit' => 'kg',
					'dimension_unit' => 'in',
					'tax_rates' =>
						array (
						),
				),
			'states' =>
				array (
				),
		),

);

$countryList = apply_filters('wfp_country_set_info', $country_data);